"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PluggyAcquirerClient = void 0;
const baseApi_1 = require("./baseApi");
/**
 * Creates a new client instance for interacting with Pluggy API for the Acquirer API
 * @constructor
 * @param API_KEY for authenticating to the API
 * @returns {PluggyAcquirerClient} a client for making requests
 */
class PluggyAcquirerClient extends baseApi_1.BaseApi {
    /**
     * Fetch acquirer sale operations
     * @returns {PageResponse<AcquirerSale>} a paging response of AcquirerSale
     */
    fetchSales(itemId) {
        return __awaiter(this, void 0, void 0, function* () {
            return this.createGetRequest('acquirer-sales', { itemId });
        });
    }
    /**
     * Fetch acquirer sale receivables
     * @returns {PageResponse<AcquirerReceivable>} a paging response of AcquirerReceivable
     */
    fetchReceivables(itemId) {
        return __awaiter(this, void 0, void 0, function* () {
            return this.createGetRequest('acquirer-receivables', { itemId });
        });
    }
    /**
     * Fetch acquirer sale anticipations
     * @returns {PageResponse<AcquirerAnticipation>} a paging response of AcquirerAnticipation
     */
    fetchAnticipations(itemId) {
        return __awaiter(this, void 0, void 0, function* () {
            return this.createGetRequest('acquirer-anticipations', { itemId });
        });
    }
}
exports.PluggyAcquirerClient = PluggyAcquirerClient;
