import { BaseApi } from './baseApi';
import { PageResponse, CreatePaymentRequest, PaymentIntent, PaymentIntentsFilters, PaymentRequest, PaymentRequestsFilters, PaymentCustomer, CreatePaymentCustomer, PaymentCustomersFilters, CreatePaymentRecipient, PaymentRecipient, PaymentRecipientsFilters, UpdatePaymentRecipient, PaymentInstitution, PaymentInstitutionsFilters, CreateBulkPaymentFields, BulkPayment, CreateSmartAccount, SmartAccount, SmartAccountBalance, PaymentReceipt, CreatePaymentIntent, SchedulePayment } from './types';
/**
 * Creates a new client instance for interacting with Pluggy API for the Payments API
 * @constructor
 * @param API_KEY for authenticating to the API
 * @returns {PluggyPaymentsClient} a client for making requests
 */
export declare class PluggyPaymentsClient extends BaseApi {
    /**
     * Creates a payment request
     * @returns {PaymentRequest} PaymentRequest object
     */
    createPaymentRequest(paymentRequest: CreatePaymentRequest): Promise<PaymentRequest>;
    /**
     * Fetch a single payment request
     * @returns {PaymentRequest} PaymentRequest object
     */
    fetchPaymentRequest(id: string): Promise<PaymentRequest>;
    /**
     * Fetch all payment requests
     * @returns {PageResponse<PaymentRequest>} paged response of payment requests
     */
    fetchPaymentRequests(options?: PaymentRequestsFilters): Promise<PageResponse<PaymentRequest>>;
    /**
     * Delete a payment request
     */
    deletePaymentRequest(id: string): Promise<void>;
    /**
     * Creates a payment intent
     * @returns {PaymentIntent} PaymentIntent object
     */
    createPaymentIntent(params: CreatePaymentIntent): Promise<PaymentIntent>;
    /**
     * Fetch a single payment intent
     * @returns {PaymentIntent} PaymentIntent object
     */
    fetchPaymentIntent(id: string): Promise<PaymentIntent>;
    /**
     * Fetch all payment intents
     * @returns {PageResponse<PaymentIntent>} paged response of payment intents
     */
    fetchPaymentIntents(options?: PaymentIntentsFilters): Promise<PageResponse<PaymentIntent>>;
    /**
     * Creates a payment customer
     * @returns {PaymentCustomer} PaymentCustomer object
     */
    createPaymentCustomer(payload: CreatePaymentCustomer): Promise<PaymentCustomer>;
    /**
     * Fetch a single payment customer
     * @returns {PaymentCustomer} PaymentCustomer object
     */
    fetchPaymentCustomer(id: string): Promise<PaymentCustomer>;
    /**
     * Fetch all payment customers
     * @returns {PageResponse<PaymentCustomer>} paged response of payment customers
     */
    fetchPaymentCustomers(options?: PaymentCustomersFilters): Promise<PageResponse<PaymentCustomer>>;
    /**
     * Delete a payment customer
     */
    deletePaymentCustomer(id: string): Promise<void>;
    updatePaymentCustomer(id: string, payload: Partial<CreatePaymentCustomer>): Promise<PaymentCustomer>;
    /**
     * Creates a payment recipient (bank account)
     * @returns {PaymentRecipient} PaymentRecipient object
     */
    createPaymentRecipient(payload: CreatePaymentRecipient): Promise<PaymentRecipient>;
    /**
     * Fetch a single payment recipient
     * @returns {PaymentRecipient} PaymentRecipient object
     */
    fetchPaymentRecipient(id: string): Promise<PaymentRecipient>;
    /**
     * Fetch all payment recipients
     * @returns {PageResponse<PaymentRecipient>} paged response of payment recipients
     */
    fetchPaymentRecipients(options?: PaymentRecipientsFilters): Promise<PageResponse<PaymentRecipient>>;
    /**
     * Delete a payment recipient
     */
    deletePaymentRecipient(id: string): Promise<void>;
    /**
     * Update a payment recipient
     * @param id ID of the payment recipient
     * @param payload Fields to update
     * @returns {PaymentRecipient} PaymentRecipient object
     */
    updatePaymentRecipient(id: string, payload: UpdatePaymentRecipient): Promise<PaymentRecipient>;
    /**
     * Fetch a single payment recipient institution
     * @returns {PaymentInstitution} PaymentInstitution object
     */
    fetchPaymentInstitution(id: string): Promise<PaymentInstitution>;
    /**
     * Fetch all payment recipient institutions
     * @returns {PageResponse<PaymentInstitution>} paged response of payment recipient institutions
     */
    fetchPaymentInstitutions(options: PaymentInstitutionsFilters): Promise<PageResponse<PaymentInstitution>>;
    /**
     * Create a bulk payment
     * @returns {BulkPayment} BulkPayment object
     */
    createBulkPayment(payload: CreateBulkPaymentFields): Promise<BulkPayment>;
    /**
     * Fetch a single bulk payment
     * @returns {BulkPayment} BulkPayment object
     */
    fetchBulkPayment(id: string): Promise<BulkPayment>;
    /**
     * Fetch all bulk payments
     * @returns {PageResponse<BulkPayment>} paged response of bulk payments
     */
    fetchBulkPayments(options?: PaymentCustomersFilters): Promise<PageResponse<BulkPayment>>;
    /** Deletes the bulk payment */
    deleteBulkPayment(id: string): Promise<void>;
    /**
     * Creates a smart account
     * @returns {SmartAccount} SmartAccount object
     */
    createSmartAccount(payload: CreateSmartAccount): Promise<SmartAccount>;
    /**
     * Fetch a single smart account
     * @returns {SmartAccount} SmartAccount object
     */
    fetchSmartAccount(id: string): Promise<SmartAccount>;
    /**
     * Fetch a smart account current balance
     * @returns {SmartAccountBalance} SmartAccountBalance object
     */
    fetchSmartAccountBalance(id: string): Promise<SmartAccountBalance>;
    /**
     * Fetch all smart accounts
     * @returns {PageResponse<SmartAccount>} paged response of smart accounts
     */
    fetchSmartAccounts(options?: PaymentCustomersFilters): Promise<PageResponse<SmartAccount>>;
    /**
     * Creates a payment request receipt
     * @param id ID of the payment request
     */
    createPaymentRequestReceipt(id: string): Promise<PaymentReceipt>;
    /**
     * Fetch all payment request receipts
     * @param id ID of the payment request
     */
    fetchPaymentRequestReceipts(id: string): Promise<PageResponse<PaymentReceipt>>;
    /**
     * Fetch a single payment request receipt
     * @param requestId ID of the payment request
     * @param receiptId ID of the payment request receipt
     */
    fetchPaymentRequestReceipt(requestId: string, receiptId: string): Promise<PaymentReceipt>;
    /**
     * Fetch all scheduled payments from a payment request
     * @param paymentRequest ID of the payment request
     */
    fetchScheduledPayments(paymentRequest: string): Promise<PageResponse<SchedulePayment>>;
    /**
     * Fetch a single scheduled payment from a payment request
     * @param paymentRequest ID of the payment request
     * @param scheduleId ID of the scheduled payment
     */
    fetchScheduledPayment(paymentRequest: string, scheduleId: string): Promise<SchedulePayment>;
    /**
     * Cancel a scheduled payment from a payment request
     * @param paymentRequest ID of the payment request
     * @param scheduleId ID of the scheduled payment
     */
    cancelScheduledPayment(paymentRequest: string, scheduleId: string): Promise<void>;
    /**
     * Cancel the payment request authorization of a scheduled payment (cancel all pending payments)
     * @param paymentRequest ID of the payment request
     */
    cancelScheduledPayments(paymentRequest: string): Promise<void>;
}
