import { CurrencyCode } from './common';
export declare enum CreditCardBrand {
    VISA = "VISA",
    MASTERCARD = "MASTERCARD",
    AMEX = "AMEX",
    CABAL = "CABAL",
    ELO = "ELO",
    OTHER = "OTHER"
}
export declare const SALE_STATUSES: readonly ["APPROVED", "CANCELLED"];
export declare type SaleStatus = typeof SALE_STATUSES[number];
export declare const RECEIVABLE_SETTLEMENT_STATUSES: readonly ["PAID", "SENT", "REJECTED", "EXPECTED", "OTHER"];
export declare type ReceivableSettlementStatus = typeof RECEIVABLE_SETTLEMENT_STATUSES[number];
export declare const ANTICIPATION_STATUSES: readonly ["SIMULATED", "REQUESTED", "CANCELLED", "IN_ANALYSIS", "APPROVED"];
export declare type AnticipationStatus = typeof ANTICIPATION_STATUSES[number];
export declare const CARD_FUNDING_SOURCES: readonly ["CREDIT", "DEBIT"];
export declare type CardFundingSource = typeof CARD_FUNDING_SOURCES[number];
export declare const SALE_PAYMENT_METHODS: readonly ["CARD", "PIX"];
export declare type SalePaymentMethod = typeof SALE_PAYMENT_METHODS[number];
export declare type SaleInstallment = {
    number: number;
    netAmount: number;
    grossAmount: number;
    receiptDate: Date;
};
export declare type DestinationAccount = {
    receivingBank: string;
    agency: string;
    account: string;
};
export declare type AcquirerSale = {
    id: string;
    itemId: string;
    description: string;
    date: Date;
    currencyCode: CurrencyCode;
    grossAmount: number;
    installmentCount?: number;
    paymentMethod?: SalePaymentMethod;
    authorizationCode?: string;
    cardFlag?: CreditCardBrand;
    cardNumber?: string;
    cardFundingSource?: CardFundingSource;
    nsu?: string;
    status?: SaleStatus;
    netAmount?: number;
    mdrFee?: number;
    mdrFeeAmount?: number;
    installments?: SaleInstallment[];
    terminalId?: string;
    operationId?: string;
};
export declare type AcquirerReceivable = {
    id: string;
    itemId: string;
    description: string;
    date: Date;
    currencyCode: CurrencyCode;
    grossAmount: number;
    netAmount: number;
    paymentId?: string;
    settlementStatus?: ReceivableSettlementStatus;
    destinationAccount?: DestinationAccount;
    cardFlag?: CreditCardBrand;
    operationId?: string;
};
export declare type AcquirerAnticipation = {
    id: string;
    itemId: string;
    description: string;
    date: Date;
    currencyCode: CurrencyCode;
    grossAmount: number;
    status?: AnticipationStatus;
    netAmount?: number;
    fee?: number;
    feeAmount?: number;
    operationId?: string;
};
