"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MOVEMENT_TYPES = exports.INVESTMENT_RATE_TYPES = exports.INVESTMENT_TRANSACTION_TYPE = exports.INVESTMENT_SUBTYPES = exports.FIXED_INCOME_INVESTMENT_SUBTYPES = exports.EQUITY_INVESTMENT_SUBTYPES = exports.SECURITY_INVESTMENT_SUBTYPES = exports.MUTUAL_FUND_INVESTMENT_SUBTYPES = exports.COE_INVESTMENT_SUBTYPES = exports.INVESTMENT_STATUS = exports.INVESTMENT_TYPES = void 0;
exports.INVESTMENT_TYPES = [
    'MUTUAL_FUND',
    'SECURITY',
    'EQUITY',
    'COE',
    'FIXED_INCOME',
    'ETF',
    'OTHER',
];
exports.INVESTMENT_STATUS = ['ACTIVE', 'PENDING', 'TOTAL_WITHDRAWAL'];
exports.COE_INVESTMENT_SUBTYPES = [
    /*! COE */
    'STRUCTURED_NOTE',
];
exports.MUTUAL_FUND_INVESTMENT_SUBTYPES = [
    /*! Default subtype */
    'INVESTMENT_FUND',
    /*! Multimercados */
    'MULTIMARKET_FUND',
    /*! Fundos de Renda Fixa */
    'FIXED_INCOME_FUND',
    /*! Fundos de Acoes */
    'STOCK_FUND',
    /*! Fundos de ETF */
    'ETF_FUND',
    /*! Fundos Offshores */
    'OFFSHORE_FUND',
    /*! Fundos de Multiestratégia */
    'FIP_FUND',
    /*! Fundos de Cambio/Cambial */
    'EXCHANGE_FUND',
];
exports.SECURITY_INVESTMENT_SUBTYPES = ['RETIREMENT'];
exports.EQUITY_INVESTMENT_SUBTYPES = [
    'STOCK',
    'ETF',
    'REAL_ESTATE_FUND',
    /*! BRAZILIAN_DEPOSITARY_RECEIPT */
    'BDR',
    'DERIVATIVES',
    'OPTION',
];
exports.FIXED_INCOME_INVESTMENT_SUBTYPES = [
    /*! FIXED_INCOME */
    'TREASURY',
    /*! Real State Credit Bill */
    'LCI',
    /*! AGRICULTURAL_CREDIT_BILL */
    'LCA',
    /*! CERTIFICATE_OF_DEPOSIT */
    'CDB',
    /*! REAL_ESTATE_RECEIVABLE_CERTIFICATE */
    'CRI',
    /*! AGRICULTURAL_RECEIVABLE_CERTIFICATE */
    'CRA',
    'CORPORATE_DEBT',
    /*! BILL_OF_EXCHANGE */
    'LC',
    'DEBENTURES',
];
exports.INVESTMENT_SUBTYPES = [
    ...exports.MUTUAL_FUND_INVESTMENT_SUBTYPES,
    ...exports.SECURITY_INVESTMENT_SUBTYPES,
    ...exports.EQUITY_INVESTMENT_SUBTYPES,
    ...exports.FIXED_INCOME_INVESTMENT_SUBTYPES,
    ...exports.COE_INVESTMENT_SUBTYPES,
    'OTHER',
];
exports.INVESTMENT_TRANSACTION_TYPE = [
    'BUY',
    'SELL',
    /*! Tax applied to the investment ie. "Come Contas" */
    'TAX',
    'TRANSFER',
];
/*!
  For extra details visit: https://docs.pluggy.ai/docs/investment-1
  RateTypes represent the index from where the rate is based.
*/
exports.INVESTMENT_RATE_TYPES = ['SELIC', 'CDI', 'EURO', 'DOLAR', 'IGPM', 'IPCA'];
/**
 * @typedef MovementType
 * The direction of the transaction.
 * If DEBIT, balance decreasing from the investment.
 * If CREDIT, balance increasing on the investment.
 */
exports.MOVEMENT_TYPES = ['DEBIT', 'CREDIT'];
