import { CurrencyCode, PageFilters } from './common';
export declare const OPPORTUNITY_TYPES: readonly ["CREDIT_CARD", "PERSONAL_LOAN", "BUSINESS_LOAN", "MORTGAGE_LOAN", "VEHICLE_LOAN", "OVERDRAFT", "OTHER_LOAN", "OTHER"];
export declare type OpportunityType = typeof OPPORTUNITY_TYPES[number];
export declare const OPPORTUNITY_DATE_TYPES: readonly ["YEARLY", "MONTHLY"];
export declare type OpportunityDateType = typeof OPPORTUNITY_DATE_TYPES[number];
export declare type Opportunity = {
    totalLimit: number | null;
    usedLimit: number | null;
    availableLimit: number | null;
    totalQuotas: number | null;
    quotasType: OpportunityDateType | null;
    interestRate: number | null;
    rateType: OpportunityDateType | null;
    type: OpportunityType;
    name: string;
    description: string | null;
    date: Date;
    currencyCode: CurrencyCode;
    itemId: string;
    id: string;
};
export declare type OpportunityFilters = PageFilters;
