import { Connector } from '../connector';
import { BulkPayment } from './bulkPayment';
import { PaymentRequest } from './paymentRequest';
export declare const PAYMENT_INTENT_ERROR_STATUSES: readonly ["PAYMENT_REJECTED", "ERROR", "CANCELED", "CONSENT_REJECTED", "EXPIRED"];
export declare const PAYMENT_INTENT_STATUSES: readonly ["PAYMENT_REJECTED", "ERROR", "CANCELED", "CONSENT_REJECTED", "EXPIRED", "STARTED", "ENQUEUED", "CONSENT_AWAITING_AUTHORIZATION", "CONSENT_AUTHORIZED", "PAYMENT_PENDING", "PAYMENT_PARTIALLY_ACCEPTED", "PAYMENT_SETTLEMENT_PROCESSING", "PAYMENT_SETTLEMENT_DEBTOR_ACCOUNT", "PAYMENT_COMPLETED"];
export declare type PaymentIntentErrorStatus = typeof PAYMENT_INTENT_ERROR_STATUSES[number];
export declare type PaymentIntentStatus = typeof PAYMENT_INTENT_STATUSES[number];
export declare type PaymentIntentPixQrData = {
    qr: string;
    value: string;
};
export declare type PaymentIntent = {
    id: string;
    connector: Connector | null;
    consentUrl: string | null;
    pixData: PaymentIntentPixQrData | null;
    paymentRequest: PaymentRequest | null;
    bulkPayment: Omit<BulkPayment, 'smartAccount' | 'paymentRequests'> | null;
    status: PaymentIntentStatus;
    createdAt: Date;
    updatedAt: Date;
};
declare type BaseCreatePaymentIntentParams = {
    connectorId: number;
    parameters: {
        cpf: string;
        cnpj?: string;
    };
};
export declare type CreatePaymentIntentPaymentRequestsParams = BaseCreatePaymentIntentParams & {
    paymentRequestId: string;
};
export declare type CreatePaymentIntentBulkParmas = BaseCreatePaymentIntentParams & {
    bulkPaymentId: string;
};
export declare type CreatePaymentIntentBulkPixQrParams = {
    bulkPaymentId: string;
    paymentMethod: 'PIX';
};
export declare type CreatePaymentIntent = CreatePaymentIntentPaymentRequestsParams | CreatePaymentIntentBulkParmas | CreatePaymentIntentBulkPixQrParams;
export {};
