import { PaymentInstitution } from './paymentInstitution';
export declare const PAYMENT_RECIPIENT_BANK_ACCOUNT_TYPES: readonly ["SAVINGS_ACCOUNT", "CHECKING_ACCOUNT", "GUARANTEED_ACCOUNT"];
/**
 * @typedef PaymentRecipientBankAccountType
 * Type of Bank Account for the Recipient
 */
export declare type PaymentRecipientBankAccountType = typeof PAYMENT_RECIPIENT_BANK_ACCOUNT_TYPES[number];
export declare type PaymentRecipientAccount = {
    type: PaymentRecipientBankAccountType;
    number: string;
    branch: string;
};
export declare type PaymentRecipient = {
    id: string;
    name: string;
    taxNumber: string;
    isDefault: boolean;
    paymentInstitution: PaymentInstitution;
    account: PaymentRecipientAccount;
    createdAt: Date;
    updatedAt: Date;
};
export declare type CreatePaymentRecipient = {
    name: string;
    taxNumber: string;
    paymentInstitutionId: string;
    isDefault?: boolean;
    account: PaymentRecipientAccount;
} | {
    pixKey: string;
} | {
    smartAccountId: string;
};
export declare type UpdatePaymentRecipient = {
    name: string;
    taxNumber: string;
    isDefault?: boolean;
    account?: PaymentRecipientAccount;
};
