import type { PaymentCustomer } from './paymentCustomer';
import { PaymentRecipient } from './paymentRecipient';
export declare const DAYS_OF_WEEK: readonly [
    'MONDAY',
    'TUESDAY',
    'WEDNESDAY',
    'THURSDAY',
    'FRIDAY',
    'SATURDAY',
    'SUNDAY'
];
export declare type DaysOfWeek = typeof DAYS_OF_WEEK[number];
export declare const PAYMENT_REQUEST_STATUS: readonly ["CREATED", "IN_PROGRESS", "COMPLETED", "SCHEDULED", "WAITING_PAYER_AUTHORIZATION", "ERROR", "REFUND_IN_PROGRESS", "REFUNDED", "REFUND_ERROR"];
/**
 * @typedef PaymentRequestStatus
 * Status of payment request where:
 * CREATED - Payment request was created
 * IN_PROGRESS - User started the payment process
 * WAITING_PAYER_AUTHORIZATION - User needs to authorize the payment in the payment institution
 * COMPLETED - Payment request was completed
 * ERROR - Payment request has an error
 */
export declare type PaymentRequestStatus = typeof PAYMENT_REQUEST_STATUS[number];
export declare type CreatePaymentRequest = {
    amount: number;
    callbackUrls?: CallbackUrls;
    description?: string;
    recipientId?: string;
    customerId?: string;
    schedule?: PaymentRequestSchedule;
    smartAccountId?: string;
    clientPaymentId?: string;
};
export declare type PaymentRequestSchedule = SingleSchedule | DailySchedule | WeeklySchedule | MonthlySchedule | CustomSchedule;
export declare type SingleSchedule = {
    type: 'SINGLE';
    date: string;
};
export declare type DailySchedule = {
    type: 'DAILY';
    startDate: string;
    occurrences: number;
};
export declare type WeeklySchedule = {
    type: 'WEEKLY';
    startDate: string;
    occurrences: number;
    dayOfWeek: DaysOfWeek;
};
export declare type MonthlySchedule = {
    type: 'MONTHLY';
    startDate: string;
    occurrences: number;
    dayOfMonth: number;
};
export declare type CustomSchedule = {
    type: 'CUSTOM';
    dates: string[];
    additionalInformation?: string;
};
export declare type PaymentRequest = {
    /**! primary identifier */
    id: string;
    /**! payment to send the user to pay */
    paymentUrl: string;
    /**! amount to be paid */
    amount: number;
    /**! description of the payment */
    description: string | null;
    /**! status of the payment request */
    status: PaymentRequestStatus;
    /**! where the user will be redirected when the payment finishes */
    callbackUrls: CallbackUrls | null;
    /** if the payment request is inside a bulk payment, primary identifier of the bulk */
    bulkPaymentId: string | null;
    /**! recipient of the payment */
    recipient: PaymentRecipient | null;
    /**! customer that will pay the payment */
    customer: PaymentCustomer | null;
    /**! fees that will be charged to the customer (related to bulk) */
    fees: number | null;
    /**! schedule of the payment */
    schedule: PaymentRequestSchedule | null;
    /**! createdAt date */
    createdAt: Date;
    /**! updatedAt date */
    updatedAt: Date;
    /**! Identification from client that can be used to track payment */
    clientPaymentId: string | null;
};
export declare type CallbackUrls = {
    success?: string;
    error?: string;
};
