import { amountToInteger } from '../utils.js';
import Fallback from './integration-bank.js';
/** @type {import('./bank.interface.js').IBank} */
export default {
    ...Fallback,
    institutionIds: ['ING_PL_INGBPLPW'],
    normalizeTransaction(transaction, booked) {
        const editedTrans = { ...transaction };
        editedTrans.date = transaction.valueDate;
        return Fallback.normalizeTransaction(transaction, booked, editedTrans);
    },
    sortTransactions(transactions = []) {
        return transactions.sort((a, b) => {
            return (Number(b.transactionId.substr(2)) - Number(a.transactionId.substr(2)));
        });
    },
    calculateStartingBalance(sortedTransactions = [], balances = []) {
        if (sortedTransactions.length) {
            const oldestTransaction = sortedTransactions[sortedTransactions.length - 1];
            const oldestKnownBalance = amountToInteger(oldestTransaction.balanceAfterTransaction.balanceAmount.amount);
            const oldestTransactionAmount = amountToInteger(oldestTransaction.transactionAmount.amount);
            return oldestKnownBalance - oldestTransactionAmount;
        }
        else {
            return amountToInteger(balances.find(balance => 'interimBooked' === balance.balanceType)
                .balanceAmount.amount);
        }
    },
};
