import { Timestamp } from './timestamp';
/**
 * Represents a node within a trinary radix trie.
 */
export type TrieNode = {
    '0'?: TrieNode;
    '1'?: TrieNode;
    '2'?: TrieNode;
    hash?: number;
};
type NumberTrieNodeKey = keyof Omit<TrieNode, 'hash'>;
export declare function emptyTrie(): TrieNode;
export declare function getKeys(trie: TrieNode): NumberTrieNodeKey[];
export declare function keyToTimestamp(key: string): number;
/**
 * Mutates `trie` to insert a node at `timestamp`
 */
export declare function insert(trie: TrieNode, timestamp: Timestamp): TrieNode;
export declare function build(timestamps: Timestamp[]): TrieNode;
export declare function diff(trie1: TrieNode, trie2: TrieNode): number | null;
export declare function prune(trie: TrieNode, n?: number): TrieNode;
export declare function debug(trie: TrieNode, k?: string, indent?: number): string;
export {};
