import { Got, Method } from 'got';
declare type QueryParameters = {
    [key: string]: number | number[] | string | string[] | boolean;
};
export declare type ClientParams = {
    /** Pluggy Client ID */
    clientId: string;
    /** Pluggy Client Secret */
    clientSecret: string;
    baseUrl?: string;
};
export declare class BaseApi {
    protected apiKey: string;
    protected clientId: string;
    protected clientSecret: string;
    protected baseUrl?: string;
    protected defaultHeaders: Record<string, string>;
    protected serviceInstance: Got;
    constructor(params: ClientParams);
    private getServiceInstance;
    protected getApiKey(): Promise<string>;
    protected createGetRequest<T>(endpoint: string, params?: QueryParameters): Promise<T>;
    protected createPostRequest<T>(endpoint: string, params?: QueryParameters, body?: Record<string, unknown>): Promise<T>;
    protected createPutRequest<T>(endpoint: string, params?: QueryParameters, body?: Record<string, unknown>): Promise<T>;
    protected createPatchRequest<T>(endpoint: string, params?: QueryParameters, body?: Record<string, unknown>): Promise<T>;
    protected createDeleteRequest<T>(endpoint: string, params?: QueryParameters, body?: Record<string, unknown>): Promise<T>;
    protected createMutationRequest<T>(method: Method, endpoint: string, params?: QueryParameters, body?: Record<string, unknown>): Promise<T>;
    protected mapToQueryString(params: QueryParameters): string;
    protected isJwtExpired(token: string): boolean;
}
export {};
