export declare const CURRENCY_CODES: readonly ["AED", "AFN", "ALL", "AMD", "ANG", "AOA", "ARS", "AUD", "AWG", "AZN", "BAM", "BBD", "BDT", "BGN", "BHD", "BIF", "BMD", "BND", "BOB", "BOV", "BRL", "BSD", "BTN", "BWP", "BYN", "BZD", "CAD", "CDF", "CHE", "CHF", "CHW", "CLF", "CLP", "COP", "COU", "CRC", "CUP", "CVE", "CZK", "DJF", "DKK", "DOP", "DZD", "EGP", "ERN", "ETB", "EUR", "FJD", "FKP", "GBP", "GEL", "GHS", "GIP", "GMD", "GNF", "GTQ", "GYD", "HKD", "HNL", "HTG", "HUF", "IDR", "ILS", "INR", "IQD", "IRR", "ISK", "JMD", "JOD", "JPY", "KES", "KGS", "KHR", "KMF", "KPW", "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LYD", "MAD", "MDL", "MGA", "MKD", "MMK", "MNT", "MOP", "MRU", "MUR", "MVR", "MWK", "MXN", "MXV", "MYR", "MZN", "NAD", "NGN", "NIO", "NOK", "NPR", "NZD", "OMR", "PAB", "PEN", "PGK", "PHP", "PKR", "PLN", "PYG", "QAR", "RON", "RSD", "CNY", "RUB", "RWF", "SAR", "SBD", "SCR", "SDG", "SEK", "SGD", "SHP", "SLE", "SLL", "SOS", "SRD", "SSP", "STN", "SVC", "SYP", "SZL", "THB", "TJS", "TMT", "TND", "TOP", "TRY", "TTD", "TWD", "TZS", "UAH", "UGX", "USD", "USN", "UYI", "UYU", "UYW", "UZS", "VED", "VES", "VND", "VUV", "WST", "XAF", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "XCD", "XDR", "XOF", "XPD", "XPF", "XPT", "XSU", "XTS", "XUA", "XXX", "YER", "ZAR", "ZMW", "ZWL"];
/**
 * @typedef CurrencyCode
 * Supported currency ISO codes (based on https://en.wikipedia.org/wiki/ISO_4217)
 */
export declare type CurrencyCode = typeof CURRENCY_CODES[number];
export declare const COUNTRY_CODES: readonly ["AR", "BR", "CO", "MX"];
/**
 * @typedef CountryCode
 *  Supported and available countries, in ISO-3166-1 alpha 2 format.
 *  Useful to filter connectors list.
 */
export declare type CountryCode = typeof COUNTRY_CODES[number];
export declare type PageResponse<T> = {
    results: T[];
    page: number;
    total: number;
    totalPages: number;
};
export declare type PageFilters = {
    /** Page to retrieve, this calculates the offset */
    page?: number;
    /** Amount of results to retrieve per page. Optional, default: 20. Maximum supported: 500. */
    pageSize?: number;
};
export declare type DateFilters = {
    /** Filter less than date. Format can be ISO Date or 'YYYY-MM-dd' string. */
    to?: string;
    /** Filter greater than date. Format can be ISO Date, or 'YYYY-MM-dd' string. */
    from?: string;
};
