import { Account, CreditData } from './account';
import { IdentityResponse } from './identity';
import { Investment, InvestmentTransaction } from './investment';
import { Item, ItemProductsStatusDetail, ItemProductState, UserAction } from './item';
import { Transaction } from './transaction';
import { ConnectorCredential } from './connector';
export declare type DeserializedAccount = Omit<Account, 'creditData'> & {
    creditData: Omit<CreditData, 'balanceCloseDate' | 'balanceDueDate'> & {
        balanceCloseDate?: string;
        balanceDueDate?: string;
    };
};
export declare type DeserializedIdentityResponse = Omit<IdentityResponse, 'birthDate' | 'createdAt' | 'updatedAt'> & {
    birthDate?: string;
    createdAt: string;
    updatedAt: string;
};
export declare type DeserializedInvestmentTransaction = Omit<InvestmentTransaction, 'date' | 'tradeDate'> & {
    date: string;
    tradeDate: string;
};
export declare type DeserializedInvestment = Omit<Investment, 'date' | 'dueDate' | 'issueDate' | 'purchaseDate' | 'transactions'> & {
    date?: string;
    dueDate?: string;
    issueDate?: string;
    purchaseDate?: string;
    transactions: DeserializedInvestmentTransaction[];
};
declare type DeserializedConnectorCredential = Omit<ConnectorCredential, 'expiresAt'> & {
    expiresAt?: string;
};
export declare type DeserializedItemProductState = Omit<ItemProductState, 'lastUpdatedAt'> & {
    lastUpdatedAt: string | null;
};
export declare type DeserializedItemProductsStatusDetail = Omit<ItemProductsStatusDetail, 'accounts' | 'creditCards' | 'transactions' | 'investments' | 'identity' | 'paymentData'> & {
    accounts: DeserializedItemProductState | null;
    creditCards: DeserializedItemProductState | null;
    transactions: DeserializedItemProductState | null;
    investments: DeserializedItemProductState | null;
    identity: DeserializedItemProductState | null;
    paymentData: DeserializedItemProductState | null;
};
export declare type DeserializedUserAction = Omit<UserAction, 'expiresAt'> & {
    expiresAt?: string;
};
export declare type DeserializedItem = Omit<Item, 'createdAt' | 'updatedAt' | 'lastUpdatedAt' | 'parameter' | 'statusDetail' | 'userAction'> & {
    parameter: DeserializedConnectorCredential | null;
    createdAt: string;
    updatedAt: string;
    lastUpdatedAt: string | null;
    statusDetail: DeserializedItemProductsStatusDetail | null;
    userAction: DeserializedUserAction | null;
};
export declare type DeserializedTransaction = Omit<Transaction, 'date'> & {
    date: string;
};
export {};
