export declare type TriggeredBy = 'CLIENT' | 'USER' | 'SYNC' | 'INTERNAL';
declare const CONNECTOR_EXECUTION_STATUSES: readonly ["LOGIN_IN_PROGRESS", "WAITING_USER_INPUT", "WAITING_USER_ACTION", "LOGIN_MFA_IN_PROGRESS", "ACCOUNTS_IN_PROGRESS", "TRANSACTIONS_IN_PROGRESS", "PAYMENT_DATA_IN_PROGRESS", "CREDITCARDS_IN_PROGRESS", "INVESTMENTS_IN_PROGRESS", "INVESTMENTS_TRANSACTIONS_IN_PROGRESS", "IDENTITY_IN_PROGRESS", "LOANS_IN_PROGRESS", "ACCOUNT_STATEMENTS_IN_PROGRESS"];
export declare type ConnectorExecutionStatus = typeof CONNECTOR_EXECUTION_STATUSES[number];
declare const EXECUTION_ERROR_CODES: readonly ["INVALID_CREDENTIALS", "ALREADY_LOGGED_IN", "UNEXPECTED_ERROR", "INVALID_CREDENTIALS_MFA", "SITE_NOT_AVAILABLE", "ACCOUNT_LOCKED", "ACCOUNT_CREDENTIALS_RESET", "CONNECTION_ERROR", "ACCOUNT_NEEDS_ACTION", "USER_AUTHORIZATION_PENDING", "USER_AUTHORIZATION_NOT_GRANTED", "USER_NOT_SUPPORTED", "USER_INPUT_TIMEOUT"];
export declare type ExecutionErrorCode = typeof EXECUTION_ERROR_CODES[number];
export declare const EXECUTION_FINISHED_STATUSES: readonly ["INVALID_CREDENTIALS", "ALREADY_LOGGED_IN", "UNEXPECTED_ERROR", "INVALID_CREDENTIALS_MFA", "SITE_NOT_AVAILABLE", "ACCOUNT_LOCKED", "ACCOUNT_CREDENTIALS_RESET", "CONNECTION_ERROR", "ACCOUNT_NEEDS_ACTION", "USER_AUTHORIZATION_PENDING", "USER_AUTHORIZATION_NOT_GRANTED", "USER_NOT_SUPPORTED", "USER_INPUT_TIMEOUT", "MERGE_ERROR", "ERROR", "SUCCESS", "PARTIAL_SUCCESS"];
export declare type ExecutionFinishedStatus = typeof EXECUTION_FINISHED_STATUSES[number];
declare const EXECUTION_STATUSES: readonly ["CREATING", "CREATE_ERROR", "CREATED", "LOGIN_IN_PROGRESS", "WAITING_USER_INPUT", "WAITING_USER_ACTION", "LOGIN_MFA_IN_PROGRESS", "ACCOUNTS_IN_PROGRESS", "TRANSACTIONS_IN_PROGRESS", "PAYMENT_DATA_IN_PROGRESS", "CREDITCARDS_IN_PROGRESS", "INVESTMENTS_IN_PROGRESS", "INVESTMENTS_TRANSACTIONS_IN_PROGRESS", "IDENTITY_IN_PROGRESS", "LOANS_IN_PROGRESS", "ACCOUNT_STATEMENTS_IN_PROGRESS", "INVALID_CREDENTIALS", "ALREADY_LOGGED_IN", "UNEXPECTED_ERROR", "INVALID_CREDENTIALS_MFA", "SITE_NOT_AVAILABLE", "ACCOUNT_LOCKED", "ACCOUNT_CREDENTIALS_RESET", "CONNECTION_ERROR", "ACCOUNT_NEEDS_ACTION", "USER_AUTHORIZATION_PENDING", "USER_AUTHORIZATION_NOT_GRANTED", "USER_NOT_SUPPORTED", "USER_INPUT_TIMEOUT", "MERGE_ERROR", "ERROR", "SUCCESS", "PARTIAL_SUCCESS"];
export declare type ExecutionStatus = typeof EXECUTION_STATUSES[number];
export declare type ExecutionErrorResult = {
    /** The specific execution error code */
    code: ExecutionErrorCode;
    /** A human-readable, short description of the error */
    message: string;
    /** The exact error message returned by the institution, if any was provided. */
    providerMessage?: string;
    /** Unstructured properties that provide additional context/information of the error.
     * Used for some specific cases only, such as Caixa PF & PJ.
     * @see https://docs.pluggy.ai/docs/errors-validations for more info. */
    attributes?: Record<string, string>;
};
export {};
