"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EXECUTION_FINISHED_STATUSES = void 0;
const CONNECTOR_EXECUTION_STATUSES = [
    'LOGIN_IN_PROGRESS',
    'WAITING_USER_INPUT',
    'WAITING_USER_ACTION',
    'LOGIN_MFA_IN_PROGRESS',
    'ACCOUNTS_IN_PROGRESS',
    'TRANSACTIONS_IN_PROGRESS',
    'PAYMENT_DATA_IN_PROGRESS',
    'CREDITCARDS_IN_PROGRESS',
    'INVESTMENTS_IN_PROGRESS',
    'INVESTMENTS_TRANSACTIONS_IN_PROGRESS',
    'IDENTITY_IN_PROGRESS',
    'LOANS_IN_PROGRESS',
    'ACCOUNT_STATEMENTS_IN_PROGRESS',
];
const EXECUTION_ERROR_CODES = [
    'INVALID_CREDENTIALS',
    'ALREADY_LOGGED_IN',
    'UNEXPECTED_ERROR',
    'INVALID_CREDENTIALS_MFA',
    'SITE_NOT_AVAILABLE',
    'ACCOUNT_LOCKED',
    'ACCOUNT_CREDENTIALS_RESET',
    'CONNECTION_ERROR',
    'ACCOUNT_NEEDS_ACTION',
    'USER_AUTHORIZATION_PENDING',
    'USER_AUTHORIZATION_NOT_GRANTED',
    'USER_NOT_SUPPORTED',
    'USER_INPUT_TIMEOUT',
];
exports.EXECUTION_FINISHED_STATUSES = [
    ...EXECUTION_ERROR_CODES,
    'MERGE_ERROR',
    'ERROR',
    'SUCCESS',
    'PARTIAL_SUCCESS',
];
const EXECUTION_STATUSES = [
    'CREATING',
    'CREATE_ERROR',
    'CREATED',
    ...CONNECTOR_EXECUTION_STATUSES,
    ...exports.EXECUTION_FINISHED_STATUSES,
];
