import { PaymentRequest } from './paymentRequest';
import { SmartAccount } from './smartAccount';
export declare const BULK_PAYMENT_STATUS: readonly ["CREATED", "TOP_UP_STARTED", "WAITING_PAYER_AUTHORIZATION", "TOP_UP_IN_PROGRESS", "PAYMENT_IN_PROGRESS", "ERROR", "COMPLETED"];
export declare type BulkPaymentStatus = typeof BULK_PAYMENT_STATUS[number];
export declare type BulkPayment = {
    id: string;
    status: BulkPaymentStatus;
    referenceId: string | null;
    createdAt: Date;
    updatedAt: Date;
    totalAmount: number;
    paymentUrl: string;
    paymentRequests: PaymentRequest[];
    smartAccount: SmartAccount;
    feesAmount: number;
    grossAmount: number;
    callbackUrls: {
        success?: string;
        error?: string;
        pending?: string;
    } | null;
};
export declare type CreateBulkPaymentFields = {
    smartAccountId: string;
    paymentRequestIds: string[];
    callbackUrls?: {
        success?: string;
        error?: string;
        pending?: string;
    };
};
