import { Connector } from "../connector";
export declare const PAYMENT_CUSTOMER_TYPE: readonly ["INDIVIDUAL", "BUSINESS"];
/**
 * @typedef PaymentCustomerType
 * Types of customers
 */
export declare type PaymentCustomerType = typeof PAYMENT_CUSTOMER_TYPE[number];
export declare type PaymentCustomer = {
    id: string;
    name: string;
    email: string;
    cpf: string;
    cnpj: string;
    type: PaymentCustomerType;
    connector: Connector | null;
    createdAt: Date;
    updatedAt: Date;
};
export declare type CreatePaymentCustomer = {
    name: string;
    email: string;
    cpf: string;
    cnpj: string;
    type: PaymentCustomerType;
};
