import { PageFilters, PageResponse } from '../common';
export declare const AUTOMATIC_PIX_PAYMENT_STATUSES: readonly ["SCHEDULED", "CREATED", "COMPLETED", "CANCELED", "ERROR"];
export declare type AutomaticPixPaymentStatus = typeof AUTOMATIC_PIX_PAYMENT_STATUSES[number];
export declare type AutomaticPixPaymentErrorDetail = {
    code: string;
    description: string;
    detail?: string;
};
export declare type AutomaticPixPayment = {
    id: string;
    status: AutomaticPixPaymentStatus;
    amount: number;
    description?: string;
    date: string;
    endToEndId?: string;
    errorDetail?: AutomaticPixPaymentErrorDetail | null;
};
export declare type ScheduleAutomaticPixPaymentRequest = {
    amount: number;
    description?: string;
    date: string;
};
export declare type RetryAutomaticPixPaymentRequest = {
    date: string;
};
export declare type AutomaticPixPaymentListResponse = PageResponse<AutomaticPixPayment>;
export declare type PaymentPixAutomaticFilters = PageFilters;
