/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.com.github.mustachejava.functions;

import java.util.Locale;
import java.util.ResourceBundle;
import java.util.function.Function;
import org.graylog.shaded.opensearch2.com.github.mustachejava.TemplateFunction;

public class BundleFunctions {
    public static Function newPreTranslate(String bundle, Locale locale) {
        return new PreTranslateFunc(bundle, locale, true);
    }

    public static Function newPreTranslateNullableLabel(String bundle, Locale locale) {
        return new PreTranslateFunc(bundle, locale, false);
    }

    public static Function newPostTranslate(String bundle, Locale locale) {
        return new PostTranslateFunc(bundle, locale, true);
    }

    public static Function newPostTranslateNullableLabel(String bundle, Locale locale) {
        return new PostTranslateFunc(bundle, locale, false);
    }

    static class PostTranslateFunc
    extends BundleFunc
    implements Function {
        private PostTranslateFunc(String bundle, Locale locale, boolean returnLabels) {
            super(bundle, locale, returnLabels);
        }

        public Object apply(Object input) {
            return super.lookup((String)input);
        }
    }

    static class PreTranslateFunc
    extends BundleFunc
    implements TemplateFunction {
        private PreTranslateFunc(String bundle, Locale locale, boolean returnLabels) {
            super(bundle, locale, returnLabels);
        }

        @Override
        public String apply(String input) {
            return super.lookup(input);
        }
    }

    private static abstract class BundleFunc {
        protected final ResourceBundle res;
        protected final boolean returnLabels;

        protected BundleFunc(String bundle, Locale locale, boolean returnLabels) {
            this.res = ResourceBundle.getBundle(bundle, locale);
            this.returnLabels = returnLabels;
        }

        protected final String lookup(String key) {
            if (this.res.containsKey(key)) {
                return this.res.getString(key);
            }
            return this.returnLabels ? key : null;
        }
    }
}

