/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.com.jcraft.jzlib;

import java.io.IOException;
import java.io.InputStream;
import org.graylog.shaded.opensearch2.com.jcraft.jzlib.GZIPException;
import org.graylog.shaded.opensearch2.com.jcraft.jzlib.Inflater;
import org.graylog.shaded.opensearch2.com.jcraft.jzlib.InflaterInputStream;

public class GZIPInputStream
extends InflaterInputStream {
    public GZIPInputStream(InputStream in) throws IOException {
        this(in, 512, true);
    }

    public GZIPInputStream(InputStream in, int size, boolean close_in) throws IOException {
        this(in, new Inflater(31), size, close_in);
        this.myinflater = true;
    }

    public GZIPInputStream(InputStream in, Inflater inflater, int size, boolean close_in) throws IOException {
        super(in, inflater, size, close_in);
    }

    public long getModifiedtime() {
        return this.inflater.istate.getGZIPHeader().getModifiedTime();
    }

    public int getOS() {
        return this.inflater.istate.getGZIPHeader().getOS();
    }

    public String getName() {
        return this.inflater.istate.getGZIPHeader().getName();
    }

    public String getComment() {
        return this.inflater.istate.getGZIPHeader().getComment();
    }

    public long getCRC() throws GZIPException {
        if (this.inflater.istate.mode != 12) {
            throw new GZIPException("checksum is not calculated yet.");
        }
        return this.inflater.istate.getGZIPHeader().getCRC();
    }

    public void readHeader() throws IOException {
        byte[] empty = "".getBytes();
        this.inflater.setOutput(empty, 0, 0);
        this.inflater.setInput(empty, 0, 0, false);
        byte[] b = new byte[10];
        int n = this.fill(b);
        if (n != 10) {
            if (n > 0) {
                this.inflater.setInput(b, 0, n, false);
                this.inflater.next_in_index = 0;
                this.inflater.avail_in = n;
            }
            throw new IOException("no input");
        }
        this.inflater.setInput(b, 0, n, false);
        byte[] b1 = new byte[1];
        do {
            byte[] tmp;
            int err;
            if (this.inflater.avail_in <= 0) {
                int i = this.in.read(b1);
                if (i <= 0) {
                    throw new IOException("no input");
                }
                this.inflater.setInput(b1, 0, 1, true);
            }
            if ((err = this.inflater.inflate(0)) == 0) continue;
            int len = 2048 - this.inflater.next_in.length;
            if (len > 0 && (n = this.fill(tmp = new byte[len])) > 0) {
                this.inflater.avail_in += this.inflater.next_in_index;
                this.inflater.next_in_index = 0;
                this.inflater.setInput(tmp, 0, n, true);
            }
            this.inflater.avail_in += this.inflater.next_in_index;
            this.inflater.next_in_index = 0;
            throw new IOException(this.inflater.msg);
        } while (this.inflater.istate.inParsingHeader());
    }

    private int fill(byte[] buf) {
        int i;
        int len = buf.length;
        int n = 0;
        do {
            i = -1;
            try {
                i = this.in.read(buf, n, buf.length - n);
            }
            catch (IOException e) {
                // empty catch block
            }
        } while (i != -1 && (n += i) < len);
        return n;
    }
}

