/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.analysis.fr;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.Analyzer;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.CharArraySet;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.LowerCaseFilter;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.StopFilter;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.StopwordAnalyzerBase;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.TokenFilter;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.TokenStream;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.WordlistLoader;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.fr.FrenchLightStemFilter;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.miscellaneous.SetKeywordMarkerFilter;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.snowball.SnowballFilter;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.standard.StandardTokenizer;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.util.ElisionFilter;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.IOUtils;

public final class FrenchAnalyzer
extends StopwordAnalyzerBase {
    public static final String DEFAULT_STOPWORD_FILE = "french_stop.txt";
    public static final CharArraySet DEFAULT_ARTICLES = CharArraySet.unmodifiableSet(new CharArraySet(Arrays.asList("l", "m", "t", "qu", "n", "s", "j", "d", "c", "jusqu", "quoiqu", "lorsqu", "puisqu"), true));
    private final CharArraySet excltable;

    public static CharArraySet getDefaultStopSet() {
        return DefaultSetHolder.DEFAULT_STOP_SET;
    }

    public FrenchAnalyzer() {
        this(DefaultSetHolder.DEFAULT_STOP_SET);
    }

    public FrenchAnalyzer(CharArraySet stopwords) {
        this(stopwords, CharArraySet.EMPTY_SET);
    }

    public FrenchAnalyzer(CharArraySet stopwords, CharArraySet stemExclutionSet) {
        super(stopwords);
        this.excltable = CharArraySet.unmodifiableSet(CharArraySet.copy(stemExclutionSet));
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        StandardTokenizer source = new StandardTokenizer();
        TokenFilter result = new ElisionFilter(source, DEFAULT_ARTICLES);
        result = new LowerCaseFilter(result);
        result = new StopFilter(result, this.stopwords);
        if (!this.excltable.isEmpty()) {
            result = new SetKeywordMarkerFilter(result, this.excltable);
        }
        result = new FrenchLightStemFilter(result);
        return new Analyzer.TokenStreamComponents(source, (TokenStream)result);
    }

    @Override
    protected TokenStream normalize(String fieldName, TokenStream in) {
        TokenFilter result = new ElisionFilter(in, DEFAULT_ARTICLES);
        result = new LowerCaseFilter(result);
        return result;
    }

    private static class DefaultSetHolder {
        static final CharArraySet DEFAULT_STOP_SET;

        private DefaultSetHolder() {
        }

        static {
            try {
                DEFAULT_STOP_SET = WordlistLoader.getSnowballWordSet(IOUtils.requireResourceNonNull(SnowballFilter.class.getResourceAsStream(FrenchAnalyzer.DEFAULT_STOPWORD_FILE), FrenchAnalyzer.DEFAULT_STOPWORD_FILE));
            }
            catch (IOException ex) {
                throw new UncheckedIOException("Unable to load default stopword set", ex);
            }
        }
    }
}

