/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.analysis.hunspell;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class RepEntry {
    private final String pattern;
    private final String replacement;
    private final boolean mustStart;
    private final boolean mustEnd;
    private final int patternLen;

    RepEntry(String rawPattern, String rawReplacement) {
        this.mustStart = rawPattern.startsWith("^");
        this.mustEnd = rawPattern.endsWith("$");
        this.pattern = rawPattern.substring(this.mustStart ? 1 : 0, rawPattern.length() - (this.mustEnd ? 1 : 0));
        this.replacement = rawReplacement.replace('_', ' ');
        this.patternLen = this.pattern.length();
    }

    boolean isMiddle() {
        return !this.mustStart && !this.mustEnd;
    }

    List<String> substitute(String word) {
        if (this.mustStart) {
            boolean matches = this.mustEnd ? word.equals(this.pattern) : word.startsWith(this.pattern);
            return matches ? Collections.singletonList(this.replacement + word.substring(this.patternLen)) : Collections.emptyList();
        }
        if (this.mustEnd) {
            return word.endsWith(this.pattern) ? Collections.singletonList(word.substring(0, word.length() - this.patternLen) + this.replacement) : Collections.emptyList();
        }
        int pos = word.indexOf(this.pattern);
        if (pos < 0) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        while (pos >= 0) {
            result.add(word.substring(0, pos) + this.replacement + word.substring(pos + this.patternLen));
            pos = word.indexOf(this.pattern, pos + 1);
        }
        return result;
    }

    public String toString() {
        return (this.mustStart ? "^" : "") + this.pattern + (this.mustEnd ? "$" : "") + "->" + this.replacement;
    }
}

