/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.analysis.ngram;

import java.util.Map;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.Tokenizer;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.TokenizerFactory;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.ngram.EdgeNGramTokenizer;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.AttributeFactory;

public class EdgeNGramTokenizerFactory
extends TokenizerFactory {
    public static final String NAME = "edgeNGram";
    private final int maxGramSize;
    private final int minGramSize;

    public EdgeNGramTokenizerFactory(Map<String, String> args) {
        super(args);
        this.minGramSize = this.getInt(args, "minGramSize", 1);
        this.maxGramSize = this.getInt(args, "maxGramSize", 1);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    public EdgeNGramTokenizerFactory() {
        throw EdgeNGramTokenizerFactory.defaultCtorException();
    }

    @Override
    public Tokenizer create(AttributeFactory factory) {
        return new EdgeNGramTokenizer(factory, this.minGramSize, this.maxGramSize);
    }
}

