/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.analysis.tokenattributes;

import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.tokenattributes.CharTermAttributeImpl;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.tokenattributes.PositionLengthAttribute;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.tokenattributes.TermFrequencyAttribute;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.AttributeImpl;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.AttributeReflector;

public class PackedTokenAttributeImpl
extends CharTermAttributeImpl
implements TypeAttribute,
PositionIncrementAttribute,
PositionLengthAttribute,
OffsetAttribute,
TermFrequencyAttribute {
    private int startOffset;
    private int endOffset;
    private String type = "word";
    private int positionIncrement = 1;
    private int positionLength = 1;
    private int termFrequency = 1;

    @Override
    public void setPositionIncrement(int positionIncrement) {
        if (positionIncrement < 0) {
            throw new IllegalArgumentException("Increment must be zero or greater: " + positionIncrement);
        }
        this.positionIncrement = positionIncrement;
    }

    @Override
    public int getPositionIncrement() {
        return this.positionIncrement;
    }

    @Override
    public void setPositionLength(int positionLength) {
        if (positionLength < 1) {
            throw new IllegalArgumentException("Position length must be 1 or greater: got " + positionLength);
        }
        this.positionLength = positionLength;
    }

    @Override
    public int getPositionLength() {
        return this.positionLength;
    }

    @Override
    public final int startOffset() {
        return this.startOffset;
    }

    @Override
    public final int endOffset() {
        return this.endOffset;
    }

    @Override
    public void setOffset(int startOffset, int endOffset) {
        if (startOffset < 0 || endOffset < startOffset) {
            throw new IllegalArgumentException("startOffset must be non-negative, and endOffset must be >= startOffset; got startOffset=" + startOffset + ",endOffset=" + endOffset);
        }
        this.startOffset = startOffset;
        this.endOffset = endOffset;
    }

    @Override
    public final String type() {
        return this.type;
    }

    @Override
    public final void setType(String type) {
        this.type = type;
    }

    @Override
    public final void setTermFrequency(int termFrequency) {
        if (termFrequency < 1) {
            throw new IllegalArgumentException("Term frequency must be 1 or greater; got " + termFrequency);
        }
        this.termFrequency = termFrequency;
    }

    @Override
    public final int getTermFrequency() {
        return this.termFrequency;
    }

    @Override
    public void clear() {
        super.clear();
        this.positionLength = 1;
        this.positionIncrement = 1;
        this.termFrequency = 1;
        this.endOffset = 0;
        this.startOffset = 0;
        this.type = "word";
    }

    @Override
    public void end() {
        super.end();
        this.positionIncrement = 0;
    }

    @Override
    public PackedTokenAttributeImpl clone() {
        return (PackedTokenAttributeImpl)super.clone();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof PackedTokenAttributeImpl) {
            PackedTokenAttributeImpl other = (PackedTokenAttributeImpl)obj;
            return this.startOffset == other.startOffset && this.endOffset == other.endOffset && this.positionIncrement == other.positionIncrement && this.positionLength == other.positionLength && (this.type == null ? other.type == null : this.type.equals(other.type)) && this.termFrequency == other.termFrequency && super.equals(obj);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int code = super.hashCode();
        code = code * 31 + this.startOffset;
        code = code * 31 + this.endOffset;
        code = code * 31 + this.positionIncrement;
        code = code * 31 + this.positionLength;
        if (this.type != null) {
            code = code * 31 + this.type.hashCode();
        }
        code = code * 31 + this.termFrequency;
        return code;
    }

    @Override
    public void copyTo(AttributeImpl target) {
        if (target instanceof PackedTokenAttributeImpl) {
            PackedTokenAttributeImpl to = (PackedTokenAttributeImpl)target;
            to.copyBuffer(this.buffer(), 0, this.length());
            to.positionIncrement = this.positionIncrement;
            to.positionLength = this.positionLength;
            to.startOffset = this.startOffset;
            to.endOffset = this.endOffset;
            to.type = this.type;
            to.termFrequency = this.termFrequency;
        } else {
            super.copyTo(target);
            ((OffsetAttribute)((Object)target)).setOffset(this.startOffset, this.endOffset);
            ((PositionIncrementAttribute)((Object)target)).setPositionIncrement(this.positionIncrement);
            ((PositionLengthAttribute)((Object)target)).setPositionLength(this.positionLength);
            ((TypeAttribute)((Object)target)).setType(this.type);
            ((TermFrequencyAttribute)((Object)target)).setTermFrequency(this.termFrequency);
        }
    }

    @Override
    public void reflectWith(AttributeReflector reflector) {
        super.reflectWith(reflector);
        reflector.reflect(OffsetAttribute.class, "startOffset", this.startOffset);
        reflector.reflect(OffsetAttribute.class, "endOffset", this.endOffset);
        reflector.reflect(PositionIncrementAttribute.class, "positionIncrement", this.positionIncrement);
        reflector.reflect(PositionLengthAttribute.class, "positionLength", this.positionLength);
        reflector.reflect(TypeAttribute.class, "type", this.type);
        reflector.reflect(TermFrequencyAttribute.class, "termFrequency", this.termFrequency);
    }
}

