/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.index;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.Codec;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.CodecReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.DocValuesFieldUpdates;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.FieldInfo;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.MergePolicy;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.SegmentCommitInfo;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.SegmentReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.Directory;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.IOContext;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.TrackingDirectoryWrapper;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.Bits;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.FixedBitSet;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.IOSupplier;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.IOUtils;

class PendingDeletes {
    protected final SegmentCommitInfo info;
    private Bits liveDocs;
    private FixedBitSet writeableLiveDocs;
    protected int pendingDeleteCount;
    boolean liveDocsInitialized;

    PendingDeletes(SegmentReader reader, SegmentCommitInfo info) {
        this(info, reader.getLiveDocs(), true);
        this.pendingDeleteCount = reader.numDeletedDocs() - info.getDelCount();
    }

    PendingDeletes(SegmentCommitInfo info) {
        this(info, null, !info.hasDeletions());
    }

    PendingDeletes(SegmentCommitInfo info, Bits liveDocs, boolean liveDocsInitialized) {
        this.info = info;
        this.liveDocs = liveDocs;
        this.pendingDeleteCount = 0;
        this.liveDocsInitialized = liveDocsInitialized;
    }

    protected FixedBitSet getMutableBits() {
        assert (this.liveDocsInitialized) : "can't delete if liveDocs are not initialized";
        if (this.writeableLiveDocs == null) {
            if (this.liveDocs != null) {
                this.writeableLiveDocs = FixedBitSet.copyOf(this.liveDocs);
            } else {
                this.writeableLiveDocs = new FixedBitSet(this.info.info.maxDoc());
                this.writeableLiveDocs.set(0, this.info.info.maxDoc());
            }
            this.liveDocs = this.writeableLiveDocs.asReadOnlyBits();
        }
        return this.writeableLiveDocs;
    }

    boolean delete(int docID) throws IOException {
        assert (this.info.info.maxDoc() > 0);
        FixedBitSet mutableBits = this.getMutableBits();
        assert (mutableBits != null);
        assert (docID >= 0 && docID < mutableBits.length()) : "out of bounds: docid=" + docID + " liveDocsLength=" + mutableBits.length() + " seg=" + this.info.info.name + " maxDoc=" + this.info.info.maxDoc();
        boolean didDelete = mutableBits.getAndClear(docID);
        if (didDelete) {
            ++this.pendingDeleteCount;
        }
        return didDelete;
    }

    Bits getLiveDocs() {
        this.writeableLiveDocs = null;
        return this.liveDocs;
    }

    Bits getHardLiveDocs() {
        return this.getLiveDocs();
    }

    protected int numPendingDeletes() {
        return this.pendingDeleteCount;
    }

    void onNewReader(CodecReader reader, SegmentCommitInfo info) throws IOException {
        if (!this.liveDocsInitialized) {
            assert (this.writeableLiveDocs == null);
            if (reader.hasDeletions()) {
                assert (this.pendingDeleteCount == 0) : "pendingDeleteCount: " + this.pendingDeleteCount;
                this.liveDocs = reader.getLiveDocs();
                assert (this.liveDocs == null || this.assertCheckLiveDocs(this.liveDocs, info.info.maxDoc(), info.getDelCount()));
            }
            this.liveDocsInitialized = true;
        }
    }

    private boolean assertCheckLiveDocs(Bits bits, int expectedLength, int expectedDeleteCount) {
        assert (bits.length() == expectedLength);
        int deletedCount = 0;
        for (int i = 0; i < bits.length(); ++i) {
            if (bits.get(i)) continue;
            ++deletedCount;
        }
        assert (deletedCount == expectedDeleteCount) : "deleted: " + deletedCount + " != expected: " + expectedDeleteCount;
        return true;
    }

    void dropChanges() {
        this.pendingDeleteCount = 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PendingDeletes(seg=").append(this.info);
        sb.append(" numPendingDeletes=").append(this.pendingDeleteCount);
        sb.append(" writeable=").append(this.writeableLiveDocs != null);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean writeLiveDocs(Directory dir) throws IOException {
        block8: {
            if (this.pendingDeleteCount == 0) {
                return false;
            }
            Bits liveDocs = this.liveDocs;
            assert (liveDocs != null);
            assert (liveDocs.length() == this.info.info.maxDoc());
            TrackingDirectoryWrapper trackingDir = new TrackingDirectoryWrapper(dir);
            boolean success = false;
            try {
                Codec codec = this.info.info.getCodec();
                codec.liveDocsFormat().writeLiveDocs(liveDocs, trackingDir, this.info, this.pendingDeleteCount, IOContext.DEFAULT);
                success = true;
                if (success) break block8;
                this.info.advanceNextWriteDelGen();
            }
            catch (Throwable throwable) {
                if (!success) {
                    this.info.advanceNextWriteDelGen();
                    for (String fileName : trackingDir.getCreatedFiles()) {
                        IOUtils.deleteFilesIgnoringExceptions(dir, fileName);
                    }
                }
                throw throwable;
            }
            for (String fileName : trackingDir.getCreatedFiles()) {
                IOUtils.deleteFilesIgnoringExceptions(dir, fileName);
            }
        }
        this.info.advanceDelGen();
        this.info.setDelCount(this.info.getDelCount() + this.pendingDeleteCount);
        this.dropChanges();
        return true;
    }

    boolean isFullyDeleted(IOSupplier<CodecReader> readerIOSupplier) throws IOException {
        return this.getDelCount() == this.info.info.maxDoc();
    }

    void onDocValuesUpdate(FieldInfo info, DocValuesFieldUpdates.Iterator iterator) throws IOException {
    }

    int numDeletesToMerge(MergePolicy policy, IOSupplier<CodecReader> readerIOSupplier) throws IOException {
        return policy.numDeletesToMerge(this.info, this.getDelCount(), readerIOSupplier);
    }

    final boolean needsRefresh(CodecReader reader) {
        return reader.getLiveDocs() != this.getLiveDocs() || reader.numDeletedDocs() != this.getDelCount();
    }

    final int getDelCount() {
        int delCount = this.info.getDelCount() + this.info.getSoftDelCount() + this.numPendingDeletes();
        return delCount;
    }

    final int numDocs() {
        return this.info.info.maxDoc() - this.getDelCount();
    }

    boolean verifyDocCounts(CodecReader reader) {
        int count = 0;
        Bits liveDocs = this.getLiveDocs();
        if (liveDocs != null) {
            for (int docID = 0; docID < this.info.info.maxDoc(); ++docID) {
                if (!liveDocs.get(docID)) continue;
                ++count;
            }
        } else {
            count = this.info.info.maxDoc();
        }
        assert (this.numDocs() == count) : "info.maxDoc=" + this.info.info.maxDoc() + " info.getDelCount()=" + this.info.getDelCount() + " info.getSoftDelCount()=" + this.info.getSoftDelCount() + " pendingDeletes=" + this.toString() + " count=" + count + " numDocs: " + this.numDocs();
        assert (reader.numDocs() == this.numDocs()) : "reader.numDocs() = " + reader.numDocs() + " numDocs() " + this.numDocs();
        assert (reader.numDeletedDocs() <= this.info.info.maxDoc()) : "delCount=" + reader.numDeletedDocs() + " info.maxDoc=" + this.info.info.maxDoc() + " rld.pendingDeleteCount=" + this.numPendingDeletes() + " info.getDelCount()=" + this.info.getDelCount();
        return true;
    }

    boolean mustInitOnDelete() {
        return false;
    }
}

