/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.index;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.CodecReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.DirectoryReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.FilterCodecReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.FilterDirectoryReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.FilterLeafReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.IndexReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.LeafReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.PendingSoftDeletes;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.SegmentCommitInfo;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.SegmentReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.DocIdSetIterator;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.FieldExistsQuery;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.Bits;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.FixedBitSet;

public final class SoftDeletesDirectoryReaderWrapper
extends FilterDirectoryReader {
    private final String field;
    private final IndexReader.CacheHelper readerCacheHelper;

    public SoftDeletesDirectoryReaderWrapper(DirectoryReader in, String field) throws IOException {
        this(in, new SoftDeletesSubReaderWrapper(Collections.emptyMap(), field));
    }

    private SoftDeletesDirectoryReaderWrapper(DirectoryReader in, SoftDeletesSubReaderWrapper wrapper) throws IOException {
        super(in, wrapper);
        this.field = wrapper.field;
        this.readerCacheHelper = in.getReaderCacheHelper() == null ? null : new FilterDirectoryReader.DelegatingCacheHelper(in.getReaderCacheHelper());
    }

    @Override
    protected DirectoryReader doWrapDirectoryReader(DirectoryReader in) throws IOException {
        HashMap<IndexReader.CacheKey, LeafReader> readerCache = new HashMap<IndexReader.CacheKey, LeafReader>();
        for (LeafReader reader : this.getSequentialSubReaders()) {
            if (reader instanceof SoftDeletesFilterLeafReader && reader.getReaderCacheHelper() != null) {
                readerCache.put(((SoftDeletesFilterLeafReader)reader).reader.getReaderCacheHelper().getKey(), reader);
                continue;
            }
            if (!(reader instanceof SoftDeletesFilterCodecReader) || reader.getReaderCacheHelper() == null) continue;
            readerCache.put(((SoftDeletesFilterCodecReader)reader).reader.getReaderCacheHelper().getKey(), reader);
        }
        return new SoftDeletesDirectoryReaderWrapper(in, new SoftDeletesSubReaderWrapper(readerCache, this.field));
    }

    @Override
    public IndexReader.CacheHelper getReaderCacheHelper() {
        return this.readerCacheHelper;
    }

    static LeafReader wrap(LeafReader reader, String field) throws IOException {
        FixedBitSet bits;
        DocIdSetIterator iterator = FieldExistsQuery.getDocValuesDocIdSetIterator(field, reader);
        if (iterator == null) {
            return reader;
        }
        Bits liveDocs = reader.getLiveDocs();
        if (liveDocs != null) {
            bits = FixedBitSet.copyOf(liveDocs);
        } else {
            bits = new FixedBitSet(reader.maxDoc());
            bits.set(0, reader.maxDoc());
        }
        int numSoftDeletes = PendingSoftDeletes.applySoftDeletes(iterator, bits);
        if (numSoftDeletes == 0) {
            return reader;
        }
        int numDeletes = reader.numDeletedDocs() + numSoftDeletes;
        int numDocs = reader.maxDoc() - numDeletes;
        assert (SoftDeletesDirectoryReaderWrapper.assertDocCounts(numDocs, numSoftDeletes, reader));
        return reader instanceof CodecReader ? new SoftDeletesFilterCodecReader((CodecReader)reader, bits, numDocs) : new SoftDeletesFilterLeafReader(reader, bits, numDocs);
    }

    private static boolean assertDocCounts(int expectedNumDocs, int numSoftDeletes, LeafReader reader) {
        if (reader instanceof SegmentReader) {
            SegmentReader segmentReader = (SegmentReader)reader;
            SegmentCommitInfo segmentInfo = segmentReader.getSegmentInfo();
            if (!segmentReader.isNRT) {
                int numDocs = segmentInfo.info.maxDoc() - segmentInfo.getSoftDelCount() - segmentInfo.getDelCount();
                assert (numDocs == expectedNumDocs) : "numDocs: " + numDocs + " expected: " + expectedNumDocs + " maxDoc: " + segmentInfo.info.maxDoc() + " getDelCount: " + segmentInfo.getDelCount() + " getSoftDelCount: " + segmentInfo.getSoftDelCount() + " numSoftDeletes: " + numSoftDeletes + " reader.numDeletedDocs(): " + reader.numDeletedDocs();
            }
        }
        return true;
    }

    static final class SoftDeletesFilterCodecReader
    extends FilterCodecReader {
        private final LeafReader reader;
        private final FixedBitSet bits;
        private final int numDocs;
        private final IndexReader.CacheHelper readerCacheHelper;

        private SoftDeletesFilterCodecReader(CodecReader reader, FixedBitSet bits, int numDocs) {
            super(reader);
            this.reader = reader;
            this.bits = bits;
            this.numDocs = numDocs;
            this.readerCacheHelper = reader.getReaderCacheHelper() == null ? null : new FilterDirectoryReader.DelegatingCacheHelper(reader.getReaderCacheHelper());
        }

        @Override
        public Bits getLiveDocs() {
            return this.bits;
        }

        @Override
        public int numDocs() {
            return this.numDocs;
        }

        @Override
        public IndexReader.CacheHelper getCoreCacheHelper() {
            return this.reader.getCoreCacheHelper();
        }

        @Override
        public IndexReader.CacheHelper getReaderCacheHelper() {
            return this.readerCacheHelper;
        }
    }

    static final class SoftDeletesFilterLeafReader
    extends FilterLeafReader {
        private final LeafReader reader;
        private final FixedBitSet bits;
        private final int numDocs;
        private final IndexReader.CacheHelper readerCacheHelper;

        private SoftDeletesFilterLeafReader(LeafReader reader, FixedBitSet bits, int numDocs) {
            super(reader);
            this.reader = reader;
            this.bits = bits;
            this.numDocs = numDocs;
            this.readerCacheHelper = reader.getReaderCacheHelper() == null ? null : new FilterDirectoryReader.DelegatingCacheHelper(reader.getReaderCacheHelper());
        }

        @Override
        public Bits getLiveDocs() {
            return this.bits;
        }

        @Override
        public int numDocs() {
            return this.numDocs;
        }

        @Override
        public IndexReader.CacheHelper getCoreCacheHelper() {
            return this.reader.getCoreCacheHelper();
        }

        @Override
        public IndexReader.CacheHelper getReaderCacheHelper() {
            return this.readerCacheHelper;
        }
    }

    private static class SoftDeletesSubReaderWrapper
    extends FilterDirectoryReader.SubReaderWrapper {
        private final Map<IndexReader.CacheKey, LeafReader> mapping;
        private final String field;

        public SoftDeletesSubReaderWrapper(Map<IndexReader.CacheKey, LeafReader> oldReadersCache, String field) {
            Objects.requireNonNull(field, "Field must not be null");
            assert (oldReadersCache != null);
            this.mapping = oldReadersCache;
            this.field = field;
        }

        @Override
        protected LeafReader[] wrap(List<? extends LeafReader> readers) {
            ArrayList<LeafReader> wrapped = new ArrayList<LeafReader>(readers.size());
            for (LeafReader leafReader : readers) {
                LeafReader wrap = this.wrap(leafReader);
                assert (wrap != null);
                if (wrap.numDocs() == 0) continue;
                wrapped.add(wrap);
            }
            return wrapped.toArray(new LeafReader[0]);
        }

        @Override
        public LeafReader wrap(LeafReader reader) {
            IndexReader.CacheHelper readerCacheHelper = reader.getReaderCacheHelper();
            if (readerCacheHelper != null && this.mapping.containsKey(readerCacheHelper.getKey())) {
                return this.mapping.get(readerCacheHelper.getKey());
            }
            try {
                return SoftDeletesDirectoryReaderWrapper.wrap(reader, this.field);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

