/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.internal.hppc;

import java.util.Arrays;
import java.util.Iterator;
import java.util.stream.LongStream;
import org.graylog.shaded.opensearch2.org.apache.lucene.internal.hppc.AbstractIterator;
import org.graylog.shaded.opensearch2.org.apache.lucene.internal.hppc.BitMixer;
import org.graylog.shaded.opensearch2.org.apache.lucene.internal.hppc.LongCursor;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.Accountable;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.ArrayUtil;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.RamUsageEstimator;

public class LongArrayList
implements Iterable<LongCursor>,
Cloneable,
Accountable {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(LongArrayList.class);
    public static final long[] EMPTY_ARRAY = new long[0];
    public long[] buffer;
    public int elementsCount;

    public LongArrayList() {
        this(4);
    }

    public LongArrayList(int expectedElements) {
        this.buffer = new long[expectedElements];
    }

    public LongArrayList(LongArrayList list) {
        this(list.size());
        this.addAll(list);
    }

    public void add(long e1) {
        this.ensureBufferSpace(1);
        this.buffer[this.elementsCount++] = e1;
    }

    public void add(long[] elements, int start, int length) {
        assert (length >= 0) : "Length must be >= 0";
        this.ensureBufferSpace(length);
        System.arraycopy(elements, start, this.buffer, this.elementsCount, length);
        this.elementsCount += length;
    }

    public final void add(long ... elements) {
        this.add(elements, 0, elements.length);
    }

    public int addAll(LongArrayList list) {
        int size = list.size();
        this.ensureBufferSpace(size);
        for (LongCursor cursor : list) {
            this.add(cursor.value);
        }
        return size;
    }

    public int addAll(Iterable<? extends LongCursor> iterable) {
        int size = 0;
        for (LongCursor longCursor : iterable) {
            this.add(longCursor.value);
            ++size;
        }
        return size;
    }

    public void insert(int index, long e1) {
        assert (index >= 0 && index <= this.size()) : "Index " + index + " out of bounds [0, " + this.size() + "].";
        this.ensureBufferSpace(1);
        System.arraycopy(this.buffer, index, this.buffer, index + 1, this.elementsCount - index);
        this.buffer[index] = e1;
        ++this.elementsCount;
    }

    public long get(int index) {
        assert (index >= 0 && index < this.size()) : "Index " + index + " out of bounds [0, " + this.size() + ").";
        return this.buffer[index];
    }

    public long set(int index, long e1) {
        assert (index >= 0 && index < this.size()) : "Index " + index + " out of bounds [0, " + this.size() + ").";
        long v = this.buffer[index];
        this.buffer[index] = e1;
        return v;
    }

    public long removeAt(int index) {
        assert (index >= 0 && index < this.size()) : "Index " + index + " out of bounds [0, " + this.size() + ").";
        long v = this.buffer[index];
        System.arraycopy(this.buffer, index + 1, this.buffer, index, --this.elementsCount - index);
        return v;
    }

    public long removeLast() {
        assert (!this.isEmpty()) : "List is empty";
        return this.buffer[--this.elementsCount];
    }

    public void removeRange(int fromIndex, int toIndex) {
        assert (fromIndex >= 0 && fromIndex <= this.size()) : "Index " + fromIndex + " out of bounds [0, " + this.size() + ").";
        assert (toIndex >= 0 && toIndex <= this.size()) : "Index " + toIndex + " out of bounds [0, " + this.size() + "].";
        assert (fromIndex <= toIndex) : "fromIndex must be <= toIndex: " + fromIndex + ", " + toIndex;
        System.arraycopy(this.buffer, toIndex, this.buffer, fromIndex, this.elementsCount - toIndex);
        int count = toIndex - fromIndex;
        this.elementsCount -= count;
    }

    public boolean removeElement(long e) {
        return this.removeFirst(e) != -1;
    }

    public int removeFirst(long e1) {
        int index = this.indexOf(e1);
        if (index >= 0) {
            this.removeAt(index);
        }
        return index;
    }

    public int removeLast(long e1) {
        int index = this.lastIndexOf(e1);
        if (index >= 0) {
            this.removeAt(index);
        }
        return index;
    }

    public int removeAll(long e) {
        int to = 0;
        for (int from = 0; from < this.elementsCount; ++from) {
            if (e == this.buffer[from]) continue;
            if (to != from) {
                this.buffer[to] = this.buffer[from];
            }
            ++to;
        }
        int deleted = this.elementsCount - to;
        this.elementsCount = to;
        return deleted;
    }

    public boolean contains(long e1) {
        return this.indexOf(e1) >= 0;
    }

    public int indexOf(long e1) {
        for (int i = 0; i < this.elementsCount; ++i) {
            if (e1 != this.buffer[i]) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(long e1) {
        for (int i = this.elementsCount - 1; i >= 0; --i) {
            if (e1 != this.buffer[i]) continue;
            return i;
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.elementsCount == 0;
    }

    public void ensureCapacity(int expectedElements) {
        if (expectedElements > this.buffer.length) {
            this.ensureBufferSpace(expectedElements - this.size());
        }
    }

    protected void ensureBufferSpace(int expectedAdditions) {
        if (this.elementsCount + expectedAdditions > this.buffer.length) {
            this.buffer = ArrayUtil.grow(this.buffer, this.elementsCount + expectedAdditions);
        }
    }

    public void resize(int newSize) {
        if (newSize <= this.buffer.length) {
            if (newSize < this.elementsCount) {
                Arrays.fill(this.buffer, newSize, this.elementsCount, 0L);
            } else {
                Arrays.fill(this.buffer, this.elementsCount, newSize, 0L);
            }
        } else {
            this.ensureCapacity(newSize);
        }
        this.elementsCount = newSize;
    }

    public int size() {
        return this.elementsCount;
    }

    public void trimToSize() {
        if (this.size() != this.buffer.length) {
            this.buffer = this.toArray();
        }
    }

    public void clear() {
        Arrays.fill(this.buffer, 0, this.elementsCount, 0L);
        this.elementsCount = 0;
    }

    public void release() {
        this.buffer = EMPTY_ARRAY;
        this.elementsCount = 0;
    }

    public long[] toArray() {
        return ArrayUtil.copyOfSubArray(this.buffer, 0, this.elementsCount);
    }

    public LongArrayList clone() {
        try {
            LongArrayList cloned = (LongArrayList)super.clone();
            cloned.buffer = (long[])this.buffer.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public int hashCode() {
        int h = 1;
        int max = this.elementsCount;
        for (int i = 0; i < max; ++i) {
            h = 31 * h + BitMixer.mix(this.buffer[i]);
        }
        return h;
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && this.getClass() == obj.getClass() && this.equalElements((LongArrayList)this.getClass().cast(obj));
    }

    protected boolean equalElements(LongArrayList other) {
        int max = this.size();
        if (other.size() != max) {
            return false;
        }
        for (int i = 0; i < max; ++i) {
            if (this.get(i) == other.get(i)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf(this.buffer);
    }

    public LongStream stream() {
        return Arrays.stream(this.buffer, 0, this.size());
    }

    public LongArrayList sort() {
        Arrays.sort(this.buffer, 0, this.elementsCount);
        return this;
    }

    public LongArrayList reverse() {
        int i = 0;
        int mid = this.elementsCount >> 1;
        int j = this.elementsCount - 1;
        while (i < mid) {
            long tmp = this.buffer[i];
            this.buffer[i] = this.buffer[j];
            this.buffer[j] = tmp;
            ++i;
            --j;
        }
        return this;
    }

    @Override
    public Iterator<LongCursor> iterator() {
        return new ValueIterator(this.buffer, this.size());
    }

    public static LongArrayList from(long ... elements) {
        LongArrayList list = new LongArrayList(elements.length);
        list.add(elements);
        return list;
    }

    static final class ValueIterator
    extends AbstractIterator<LongCursor> {
        private final LongCursor cursor = new LongCursor();
        private final long[] buffer;
        private final int size;

        public ValueIterator(long[] buffer, int size) {
            this.cursor.index = -1;
            this.size = size;
            this.buffer = buffer;
        }

        @Override
        protected LongCursor fetch() {
            if (this.cursor.index + 1 == this.size) {
                return (LongCursor)this.done();
            }
            this.cursor.value = this.buffer[++this.cursor.index];
            return this.cursor;
        }
    }
}

