/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.internal.vectorization;

import java.io.IOException;
import java.lang.foreign.MemorySegment;
import java.util.Optional;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.VectorSimilarityFunction;
import org.graylog.shaded.opensearch2.org.apache.lucene.internal.vectorization.Lucene99MemorySegmentByteVectorScorer;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.FilterIndexInput;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.IndexInput;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.MemorySegmentAccessInput;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.hnsw.RandomAccessVectorValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.hnsw.RandomVectorScorer;

/*
 * Exception performing whole class analysis ignored.
 */
abstract class Lucene99MemorySegmentByteVectorScorer
extends RandomVectorScorer.AbstractRandomVectorScorer {
    final int vectorByteSize;
    final MemorySegmentAccessInput input;
    final MemorySegment query;
    byte[] scratch;

    public static Optional<Lucene99MemorySegmentByteVectorScorer> create(VectorSimilarityFunction type, IndexInput input, RandomAccessVectorValues values, byte[] queryVector) {
        if (!((input = FilterIndexInput.unwrapOnlyTest(input)) instanceof MemorySegmentAccessInput)) {
            return Optional.empty();
        }
        MemorySegmentAccessInput msInput = (MemorySegmentAccessInput)input;
        Lucene99MemorySegmentByteVectorScorer.checkInvariants((int)values.size(), (int)values.getVectorByteLength(), (IndexInput)input);
        if (type == VectorSimilarityFunction.COSINE) {
            return Optional.of(new CosineScorer(msInput, values, queryVector));
        }
        if (type == VectorSimilarityFunction.DOT_PRODUCT) {
            return Optional.of(new DotProductScorer(msInput, values, queryVector));
        }
        if (type == VectorSimilarityFunction.EUCLIDEAN) {
            return Optional.of(new EuclideanScorer(msInput, values, queryVector));
        }
        if (type == VectorSimilarityFunction.MAXIMUM_INNER_PRODUCT) {
            return Optional.of(new MaxInnerProductScorer(msInput, values, queryVector));
        }
        throw new IllegalArgumentException("unknown type: " + type);
    }

    Lucene99MemorySegmentByteVectorScorer(MemorySegmentAccessInput input, RandomAccessVectorValues values, byte[] queryVector) {
        super(values);
        this.input = input;
        this.vectorByteSize = values.getVectorByteLength();
        this.query = MemorySegment.ofArray(queryVector);
    }

    final MemorySegment getSegment(int ord) throws IOException {
        this.checkOrdinal(ord);
        long byteOffset = (long)ord * (long)this.vectorByteSize;
        MemorySegment seg = this.input.segmentSliceOrNull(byteOffset, (long)this.vectorByteSize);
        if (seg == null) {
            if (this.scratch == null) {
                this.scratch = new byte[this.vectorByteSize];
            }
            this.input.readBytes(byteOffset, this.scratch, 0, this.vectorByteSize);
            seg = MemorySegment.ofArray(this.scratch);
        }
        return seg;
    }

    static void checkInvariants(int maxOrd, int vectorByteLength, IndexInput input) {
        if (input.length() < (long)vectorByteLength * (long)maxOrd) {
            throw new IllegalArgumentException("input length is less than expected vector data");
        }
    }

    final void checkOrdinal(int ord) {
        if (ord < 0 || ord >= this.maxOrd()) {
            throw new IllegalArgumentException("illegal ordinal: " + ord);
        }
    }
}

