/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.sandbox.facet.cutters.ranges;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.apache.lucene.sandbox.facet.iterators.OrdinalIterator;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.FixedBitSet;

interface IntervalTracker
extends OrdinalIterator {
    public void set(int var1);

    public void clear();

    public boolean get(int var1);

    public void freeze();

    public static class MultiIntervalTracker
    implements IntervalTracker {
        private FixedBitSet tracker;
        private int trackerState;
        private int bitFrom;
        private int intervalsWithHit;

        MultiIntervalTracker(int size) {
            this.tracker = new FixedBitSet(size);
        }

        @Override
        public void set(int i) {
            this.tracker.set(i);
        }

        @Override
        public void clear() {
            this.tracker.clear();
            this.bitFrom = 0;
            this.trackerState = 0;
            this.intervalsWithHit = 0;
        }

        @Override
        public boolean get(int index) {
            return this.tracker.get(index);
        }

        @Override
        public void freeze() {
            this.intervalsWithHit = this.tracker.cardinality();
        }

        @Override
        public int nextOrd() throws IOException {
            if (this.trackerState == this.intervalsWithHit) {
                return -1;
            }
            ++this.trackerState;
            int nextSetBit = this.tracker.nextSetBit(this.bitFrom);
            this.bitFrom = nextSetBit + 1;
            return nextSetBit;
        }
    }
}

