/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.sandbox.facet.cutters.ranges;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.graylog.shaded.opensearch2.org.apache.lucene.facet.MultiLongValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.facet.MultiLongValuesSource;
import org.graylog.shaded.opensearch2.org.apache.lucene.facet.range.LongRange;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.opensearch2.org.apache.lucene.sandbox.facet.cutters.LeafFacetCutter;
import org.graylog.shaded.opensearch2.org.apache.lucene.sandbox.facet.cutters.ranges.LongRangeFacetCutter;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.LongValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.LongValuesSource;

class NonOverlappingLongRangeFacetCutter
extends LongRangeFacetCutter {
    NonOverlappingLongRangeFacetCutter(MultiLongValuesSource longValuesSource, LongValuesSource singleLongValuesSource, LongRange[] longRanges) {
        super(longValuesSource, singleLongValuesSource, longRanges);
    }

    @Override
    List<LongRangeFacetCutter.InclusiveRange> buildElementaryIntervals() {
        ArrayList<LongRangeFacetCutter.InclusiveRange> elementaryIntervals = new ArrayList<LongRangeFacetCutter.InclusiveRange>();
        long prev = Long.MIN_VALUE;
        for (LongRangeFacetCutter.LongRangeAndPos range : this.sortedRanges) {
            if (range.range().min > prev) {
                elementaryIntervals.add(new LongRangeFacetCutter.InclusiveRange(prev, range.range().min - 1L));
            }
            elementaryIntervals.add(new LongRangeFacetCutter.InclusiveRange(range.range().min, range.range().max));
            prev = range.range().max + 1L;
        }
        if (!elementaryIntervals.isEmpty()) {
            long lastEnd = ((LongRangeFacetCutter.InclusiveRange)elementaryIntervals.get(elementaryIntervals.size() - 1)).end();
            if (lastEnd < Long.MAX_VALUE) {
                elementaryIntervals.add(new LongRangeFacetCutter.InclusiveRange(lastEnd + 1L, Long.MAX_VALUE));
            }
        } else {
            elementaryIntervals.add(new LongRangeFacetCutter.InclusiveRange(Long.MIN_VALUE, Long.MAX_VALUE));
        }
        return elementaryIntervals;
    }

    @Override
    public LeafFacetCutter createLeafCutter(LeafReaderContext context) throws IOException {
        if (this.singleValues != null) {
            LongValues values = this.singleValues.getValues(context, null);
            return new NonOverlappingLongRangeSingleValueLeafFacetCutter(values, this.boundaries, this.pos);
        }
        MultiLongValues values = this.valuesSource.getValues(context);
        return new NonOverlappingLongRangeMultiValueLeafFacetCutter(values, this.boundaries, this.pos);
    }

    static class NonOverlappingLongRangeSingleValueLeafFacetCutter
    extends LongRangeFacetCutter.LongRangeSingleValuedLeafFacetCutter {
        NonOverlappingLongRangeSingleValueLeafFacetCutter(LongValues longValues, long[] boundaries, int[] pos) {
            super(longValues, boundaries, pos);
        }

        @Override
        public int nextOrd() throws IOException {
            if (this.elementaryIntervalOrd == -1) {
                return -1;
            }
            int result = this.pos[this.elementaryIntervalOrd];
            this.elementaryIntervalOrd = -1;
            return result != -1 ? result : -1;
        }
    }

    static class NonOverlappingLongRangeMultiValueLeafFacetCutter
    extends LongRangeFacetCutter.LongRangeMultivaluedLeafFacetCutter {
        NonOverlappingLongRangeMultiValueLeafFacetCutter(MultiLongValues longValues, long[] boundaries, int[] pos) {
            super(longValues, boundaries, pos);
        }

        @Override
        public int nextOrd() throws IOException {
            int ordinal;
            int result;
            do {
                if ((ordinal = this.elementaryIntervalTracker.nextOrd()) != -1) continue;
                return -1;
            } while ((result = this.pos[ordinal]) == -1);
            return result;
        }
    }
}

