/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.sandbox.facet.cutters.ranges;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.graylog.shaded.opensearch2.org.apache.lucene.facet.MultiLongValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.facet.MultiLongValuesSource;
import org.graylog.shaded.opensearch2.org.apache.lucene.facet.range.LongRange;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.opensearch2.org.apache.lucene.internal.hppc.IntCursor;
import org.graylog.shaded.opensearch2.org.apache.lucene.sandbox.facet.cutters.LeafFacetCutter;
import org.graylog.shaded.opensearch2.org.apache.lucene.sandbox.facet.cutters.ranges.IntervalTracker;
import org.graylog.shaded.opensearch2.org.apache.lucene.sandbox.facet.cutters.ranges.LongRangeFacetCutter;
import org.graylog.shaded.opensearch2.org.apache.lucene.sandbox.facet.cutters.ranges.LongRangeNode;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.LongValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.LongValuesSource;

class OverlappingLongRangeFacetCutter
extends LongRangeFacetCutter {
    private final LongRangeNode root;

    OverlappingLongRangeFacetCutter(MultiLongValuesSource longValuesSource, LongValuesSource singleLongValuesSource, LongRange[] longRanges) {
        super(longValuesSource, singleLongValuesSource, longRanges);
        this.root = OverlappingLongRangeFacetCutter.split(0, this.elementaryIntervals.size(), this.elementaryIntervals);
        for (LongRangeFacetCutter.LongRangeAndPos range : this.sortedRanges) {
            this.root.addOutputs(range);
        }
    }

    @Override
    List<LongRangeFacetCutter.InclusiveRange> buildElementaryIntervals() {
        long prev;
        HashMap<Long, Integer> endsMap = new HashMap<Long, Integer>();
        endsMap.put(Long.MIN_VALUE, 1);
        endsMap.put(Long.MAX_VALUE, 2);
        for (LongRangeFacetCutter.LongRangeAndPos rangeAndPos : this.sortedRanges) {
            Integer cur = (Integer)endsMap.get(rangeAndPos.range().min);
            if (cur == null) {
                endsMap.put(rangeAndPos.range().min, 1);
            } else {
                endsMap.put(rangeAndPos.range().min, cur | 1);
            }
            cur = (Integer)endsMap.get(rangeAndPos.range().max);
            if (cur == null) {
                endsMap.put(rangeAndPos.range().max, 2);
                continue;
            }
            endsMap.put(rangeAndPos.range().max, cur | 2);
        }
        ArrayList endsList = new ArrayList(endsMap.keySet());
        Collections.sort(endsList);
        ArrayList<LongRangeFacetCutter.InclusiveRange> elementaryIntervals = new ArrayList<LongRangeFacetCutter.InclusiveRange>();
        int upto = 1;
        long v = (Long)endsList.get(0);
        if ((Integer)endsMap.get(v) == 3) {
            elementaryIntervals.add(new LongRangeFacetCutter.InclusiveRange(v, v));
            prev = v + 1L;
        } else {
            prev = v;
        }
        while (upto < endsList.size()) {
            v = (Long)endsList.get(upto);
            int flags = (Integer)endsMap.get(v);
            if (flags == 3) {
                if (v > prev) {
                    elementaryIntervals.add(new LongRangeFacetCutter.InclusiveRange(prev, v - 1L));
                }
                elementaryIntervals.add(new LongRangeFacetCutter.InclusiveRange(v, v));
                prev = v + 1L;
            } else if (flags == 1) {
                if (v > prev) {
                    elementaryIntervals.add(new LongRangeFacetCutter.InclusiveRange(prev, v - 1L));
                }
                prev = v;
            } else {
                assert (flags == 2);
                elementaryIntervals.add(new LongRangeFacetCutter.InclusiveRange(prev, v));
                prev = v + 1L;
            }
            ++upto;
        }
        return elementaryIntervals;
    }

    private static LongRangeNode split(int start, int end, List<LongRangeFacetCutter.InclusiveRange> elementaryIntervals) {
        if (start == end - 1) {
            LongRangeFacetCutter.InclusiveRange range = elementaryIntervals.get(start);
            return new LongRangeNode(range.start(), range.end(), null, null);
        }
        int mid = start + end >>> 1;
        LongRangeNode left = OverlappingLongRangeFacetCutter.split(start, mid, elementaryIntervals);
        LongRangeNode right = OverlappingLongRangeFacetCutter.split(mid, end, elementaryIntervals);
        return new LongRangeNode(left.start, right.end, left, right);
    }

    @Override
    public LeafFacetCutter createLeafCutter(LeafReaderContext context) throws IOException {
        if (this.singleValues != null) {
            LongValues values = this.singleValues.getValues(context, null);
            return new OverlappingSingleValuedRangeLeafFacetCutter(values, this.boundaries, this.pos, this.requestedRangeCount, this.root);
        }
        MultiLongValues values = this.valuesSource.getValues(context);
        return new OverlappingMultivaluedRangeLeafFacetCutter(values, this.boundaries, this.pos, this.requestedRangeCount, this.root);
    }

    static class OverlappingSingleValuedRangeLeafFacetCutter
    extends LongRangeFacetCutter.LongRangeSingleValuedLeafFacetCutter {
        private final LongRangeNode elementaryIntervalRoot;
        private int elementaryIntervalUpto;

        OverlappingSingleValuedRangeLeafFacetCutter(LongValues longValues, long[] boundaries, int[] pos, int requestedRangeCount, LongRangeNode elementaryIntervalRoot) {
            super(longValues, boundaries, pos);
            this.requestedIntervalTracker = new IntervalTracker.MultiIntervalTracker(requestedRangeCount);
            this.elementaryIntervalRoot = elementaryIntervalRoot;
        }

        @Override
        void maybeRollUp(IntervalTracker rollUpInto) {
            this.elementaryIntervalUpto = 0;
            this.rollupSingleValued(this.elementaryIntervalRoot);
        }

        private boolean rollupSingleValued(LongRangeNode node) {
            boolean containedHit;
            if (node.left != null) {
                containedHit = this.rollupSingleValued(node.left);
                containedHit |= this.rollupSingleValued(node.right);
            } else {
                containedHit = this.elementaryIntervalUpto == this.elementaryIntervalOrd;
                ++this.elementaryIntervalUpto;
            }
            if (containedHit && node.outputs != null) {
                for (IntCursor rangeIndex : node.outputs) {
                    this.requestedIntervalTracker.set(rangeIndex.value);
                }
            }
            return containedHit;
        }

        @Override
        public int nextOrd() throws IOException {
            if (this.requestedIntervalTracker == null) {
                return -1;
            }
            return this.requestedIntervalTracker.nextOrd();
        }
    }

    static class OverlappingMultivaluedRangeLeafFacetCutter
    extends LongRangeFacetCutter.LongRangeMultivaluedLeafFacetCutter {
        private final LongRangeNode elementaryIntervalRoot;
        private int elementaryIntervalUpto;

        OverlappingMultivaluedRangeLeafFacetCutter(MultiLongValues longValues, long[] boundaries, int[] pos, int requestedRangeCount, LongRangeNode elementaryIntervalRoot) {
            super(longValues, boundaries, pos);
            this.requestedIntervalTracker = new IntervalTracker.MultiIntervalTracker(requestedRangeCount);
            this.elementaryIntervalRoot = elementaryIntervalRoot;
        }

        @Override
        void maybeRollUp(IntervalTracker rollUpInto) {
            this.elementaryIntervalUpto = 0;
            this.rollupMultiValued(this.elementaryIntervalRoot);
        }

        private boolean rollupMultiValued(LongRangeNode node) {
            boolean containedHit;
            if (node.left != null) {
                containedHit = this.rollupMultiValued(node.left);
                containedHit |= this.rollupMultiValued(node.right);
            } else {
                containedHit = this.elementaryIntervalTracker.get(this.elementaryIntervalUpto);
                ++this.elementaryIntervalUpto;
            }
            if (containedHit && node.outputs != null) {
                for (IntCursor rangeIndex : node.outputs) {
                    this.requestedIntervalTracker.set(rangeIndex.value);
                }
            }
            return containedHit;
        }

        @Override
        public int nextOrd() throws IOException {
            if (this.requestedIntervalTracker == null) {
                return -1;
            }
            return this.requestedIntervalTracker.nextOrd();
        }
    }
}

