/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.sandbox.facet.recorders;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.opensearch2.org.apache.lucene.sandbox.facet.cutters.FacetCutter;
import org.graylog.shaded.opensearch2.org.apache.lucene.sandbox.facet.iterators.OrdinalIterator;
import org.graylog.shaded.opensearch2.org.apache.lucene.sandbox.facet.recorders.FacetRecorder;
import org.graylog.shaded.opensearch2.org.apache.lucene.sandbox.facet.recorders.LeafFacetRecorder;

public final class MultiFacetsRecorder
implements FacetRecorder {
    private final FacetRecorder[] delegates;

    public MultiFacetsRecorder(FacetRecorder ... delegates) {
        this.delegates = delegates;
    }

    @Override
    public LeafFacetRecorder getLeafRecorder(LeafReaderContext context) throws IOException {
        LeafFacetRecorder[] leafDelegates = new LeafFacetRecorder[this.delegates.length];
        for (int i = 0; i < this.delegates.length; ++i) {
            leafDelegates[i] = this.delegates[i].getLeafRecorder(context);
        }
        return new MultiFacetsLeafRecorder(leafDelegates);
    }

    @Override
    public OrdinalIterator recordedOrds() {
        throw new UnsupportedOperationException("Not supported, call recordedOrds for sub-recorders instead");
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException("Not supported, call isEmpty for sub-recorders instead");
    }

    @Override
    public void reduce(FacetCutter facetCutter) throws IOException {
        for (FacetRecorder recorder : this.delegates) {
            recorder.reduce(facetCutter);
        }
    }

    @Override
    public boolean contains(int ordinal) {
        throw new UnsupportedOperationException("Not supported, call contains for sub-recorders instead");
    }

    private static final class MultiFacetsLeafRecorder
    implements LeafFacetRecorder {
        private final LeafFacetRecorder[] delegates;

        private MultiFacetsLeafRecorder(LeafFacetRecorder[] delegates) {
            this.delegates = delegates;
        }

        @Override
        public void record(int docId, int facetOrd) throws IOException {
            for (LeafFacetRecorder leafRecorder : this.delegates) {
                leafRecorder.record(docId, facetOrd);
            }
        }
    }
}

