/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.sandbox.search;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import org.graylog.shaded.opensearch2.org.apache.lucene.internal.hppc.IntArrayList;
import org.graylog.shaded.opensearch2.org.apache.lucene.internal.hppc.IntCursor;
import org.graylog.shaded.opensearch2.org.apache.lucene.sandbox.search.QueryProfilerBreakdown;
import org.graylog.shaded.opensearch2.org.apache.lucene.sandbox.search.QueryProfilerResult;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Query;

class QueryProfilerTree {
    private final ArrayList<QueryProfilerBreakdown> breakdowns = new ArrayList(10);
    private final ArrayList<IntArrayList> tree;
    private final ArrayList<Query> queries;
    private final IntArrayList roots;
    private final Deque<Integer> stack = new ArrayDeque<Integer>(10);
    private int currentToken = 0;
    private long rewriteTime;
    private long rewriteScratch;

    public QueryProfilerTree() {
        this.tree = new ArrayList(10);
        this.queries = new ArrayList(10);
        this.roots = new IntArrayList(10);
    }

    public QueryProfilerBreakdown getProfileBreakdown(Query query) {
        int token = this.currentToken++;
        boolean stackEmpty = this.stack.isEmpty();
        if (stackEmpty) {
            this.roots.add(token);
            this.stack.add(token);
            return this.addDependencyNode(query, token);
        }
        this.updateParent(token);
        ++this.currentToken;
        this.stack.add(token);
        return this.addDependencyNode(query, token);
    }

    private QueryProfilerBreakdown addDependencyNode(Query query, int token) {
        this.tree.add(new IntArrayList(5));
        this.queries.add(query);
        QueryProfilerBreakdown breakdown = this.createProfileBreakdown();
        this.breakdowns.add(token, breakdown);
        return breakdown;
    }

    private QueryProfilerBreakdown createProfileBreakdown() {
        return new QueryProfilerBreakdown();
    }

    public void pollLast() {
        this.stack.pollLast();
    }

    public List<QueryProfilerResult> getTree() {
        ArrayList<QueryProfilerResult> results = new ArrayList<QueryProfilerResult>(this.roots.size());
        for (IntCursor root : this.roots) {
            results.add(this.doGetTree(root.value));
        }
        return results;
    }

    private QueryProfilerResult doGetTree(int token) {
        Query query = this.queries.get(token);
        QueryProfilerBreakdown breakdown = this.breakdowns.get(token);
        IntArrayList children = this.tree.get(token);
        List<QueryProfilerResult> childrenProfileResults = Collections.emptyList();
        if (children != null) {
            childrenProfileResults = new ArrayList(children.size());
            for (IntCursor child : children) {
                QueryProfilerResult childNode = this.doGetTree(child.value);
                childrenProfileResults.add(childNode);
            }
        }
        String type = this.getTypeFromQuery(query);
        String description = this.getDescriptionFromQuery(query);
        return new QueryProfilerResult(type, description, breakdown.toBreakdownMap(), breakdown.toTotalTime(), childrenProfileResults);
    }

    private String getTypeFromQuery(Query query) {
        if (query.getClass().getSimpleName().isEmpty()) {
            return query.getClass().getSuperclass().getSimpleName();
        }
        return query.getClass().getSimpleName();
    }

    private String getDescriptionFromQuery(Query query) {
        return query.toString();
    }

    private void updateParent(int childToken) {
        Integer parent = this.stack.peekLast();
        IntArrayList parentNode = this.tree.get(parent);
        parentNode.add(childToken);
        this.tree.set(parent, parentNode);
    }

    public void startRewriteTime() {
        assert (this.rewriteScratch == 0L);
        this.rewriteScratch = System.nanoTime();
    }

    public long stopAndAddRewriteTime() {
        long time = Math.max(1L, System.nanoTime() - this.rewriteScratch);
        this.rewriteTime += time;
        this.rewriteScratch = 0L;
        return time;
    }

    public long getRewriteTime() {
        return this.rewriteTime;
    }
}

