/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.LeafReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.ConjunctionDISI;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.DocIdSetIterator;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Explanation;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.FilteredDocIdSetIterator;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.IndexSearcher;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Query;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.QueryVisitor;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.ScoreDoc;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.ScoreMode;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Scorer;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.TopDocs;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.TotalHits;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.VectorScorer;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Weight;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.BitSet;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.BitSetIterator;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.Bits;

abstract class AbstractVectorSimilarityQuery
extends Query {
    protected final String field;
    protected final float traversalSimilarity;
    protected final float resultSimilarity;
    protected final Query filter;

    AbstractVectorSimilarityQuery(String field, float traversalSimilarity, float resultSimilarity, Query filter) {
        if (traversalSimilarity > resultSimilarity) {
            throw new IllegalArgumentException("traversalSimilarity should be <= resultSimilarity");
        }
        this.field = Objects.requireNonNull(field, "field");
        this.traversalSimilarity = traversalSimilarity;
        this.resultSimilarity = resultSimilarity;
        this.filter = filter;
    }

    abstract VectorScorer createVectorScorer(LeafReaderContext var1) throws IOException;

    protected abstract TopDocs approximateSearch(LeafReaderContext var1, Bits var2, int var3) throws IOException;

    @Override
    public Weight createWeight(final IndexSearcher searcher, ScoreMode scoreMode, final float boost) throws IOException {
        return new Weight(this){
            final Weight filterWeight;
            {
                super(query);
                this.filterWeight = AbstractVectorSimilarityQuery.this.filter == null ? null : searcher.createWeight(searcher.rewrite(AbstractVectorSimilarityQuery.this.filter), ScoreMode.COMPLETE_NO_SCORES, 1.0f);
            }

            @Override
            public Explanation explain(LeafReaderContext context, int doc) throws IOException {
                Scorer filterScorer;
                if (this.filterWeight != null && ((filterScorer = this.filterWeight.scorer(context)) == null || filterScorer.iterator().advance(doc) > doc)) {
                    return Explanation.noMatch("Doc does not match the filter", new Explanation[0]);
                }
                VectorScorer scorer = AbstractVectorSimilarityQuery.this.createVectorScorer(context);
                if (scorer == null) {
                    return Explanation.noMatch("Not indexed as the correct vector field", new Explanation[0]);
                }
                DocIdSetIterator iterator = scorer.iterator();
                int docId = iterator.advance(doc);
                if (docId == doc) {
                    float score = scorer.score();
                    if (score >= AbstractVectorSimilarityQuery.this.resultSimilarity) {
                        return Explanation.match((Number)Float.valueOf(boost * score), "Score above threshold", new Explanation[0]);
                    }
                    return Explanation.noMatch("Score below threshold", new Explanation[0]);
                }
                return Explanation.noMatch("No vector found for doc", new Explanation[0]);
            }

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                BitSet acceptDocs;
                LeafReader leafReader = context.reader();
                final Bits liveDocs = leafReader.getLiveDocs();
                if (this.filterWeight == null) {
                    TopDocs results = AbstractVectorSimilarityQuery.this.approximateSearch(context, liveDocs, Integer.MAX_VALUE);
                    if (results.scoreDocs.length == 0) {
                        return null;
                    }
                    return VectorSimilarityScorer.fromScoreDocs(this, boost, results.scoreDocs);
                }
                Scorer scorer = this.filterWeight.scorer(context);
                if (scorer == null) {
                    return null;
                }
                if (liveDocs == null && scorer.iterator() instanceof BitSetIterator) {
                    BitSetIterator bitSetIterator = (BitSetIterator)scorer.iterator();
                    acceptDocs = bitSetIterator.getBitSet();
                } else {
                    FilteredDocIdSetIterator filtered = new FilteredDocIdSetIterator(scorer.iterator()){

                        @Override
                        protected boolean match(int doc) {
                            return liveDocs == null || liveDocs.get(doc);
                        }
                    };
                    acceptDocs = BitSet.of(filtered, leafReader.maxDoc());
                }
                int cardinality = acceptDocs.cardinality();
                if (cardinality == 0) {
                    return null;
                }
                TopDocs results = AbstractVectorSimilarityQuery.this.approximateSearch(context, acceptDocs, cardinality);
                if (results.totalHits.relation == TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO) {
                    return VectorSimilarityScorer.fromAcceptDocs(this, boost, AbstractVectorSimilarityQuery.this.createVectorScorer(context), new BitSetIterator(acceptDocs, cardinality), AbstractVectorSimilarityQuery.this.resultSimilarity);
                }
                if (results.scoreDocs.length == 0) {
                    return null;
                }
                return VectorSimilarityScorer.fromScoreDocs(this, boost, results.scoreDocs);
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return true;
            }
        };
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            visitor.visitLeaf(this);
        }
    }

    @Override
    public boolean equals(Object o) {
        return this.sameClassAs(o) && Objects.equals(this.field, ((AbstractVectorSimilarityQuery)o).field) && Float.compare(((AbstractVectorSimilarityQuery)o).traversalSimilarity, this.traversalSimilarity) == 0 && Float.compare(((AbstractVectorSimilarityQuery)o).resultSimilarity, this.resultSimilarity) == 0 && Objects.equals(this.filter, ((AbstractVectorSimilarityQuery)o).filter);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.field, Float.valueOf(this.traversalSimilarity), Float.valueOf(this.resultSimilarity), this.filter);
    }

    private static class VectorSimilarityScorer
    extends Scorer {
        final DocIdSetIterator iterator;
        final float[] cachedScore;

        VectorSimilarityScorer(Weight weight, DocIdSetIterator iterator, float[] cachedScore) {
            super(weight);
            this.iterator = iterator;
            this.cachedScore = cachedScore;
        }

        static VectorSimilarityScorer fromScoreDocs(Weight weight, final float boost, final ScoreDoc[] scoreDocs) {
            Arrays.sort(scoreDocs, Comparator.comparingInt(scoreDoc -> scoreDoc.doc));
            final float[] cachedScore = new float[1];
            DocIdSetIterator iterator = new DocIdSetIterator(){
                int index = -1;

                @Override
                public int docID() {
                    if (this.index < 0) {
                        return -1;
                    }
                    if (this.index >= scoreDocs.length) {
                        return Integer.MAX_VALUE;
                    }
                    cachedScore[0] = boost * scoreDocs[this.index].score;
                    return scoreDocs[this.index].doc;
                }

                @Override
                public int nextDoc() {
                    ++this.index;
                    return this.docID();
                }

                @Override
                public int advance(int target) {
                    this.index = Arrays.binarySearch(scoreDocs, new ScoreDoc(target, 0.0f), Comparator.comparingInt(scoreDoc -> scoreDoc.doc));
                    if (this.index < 0) {
                        this.index = -1 - this.index;
                    }
                    return this.docID();
                }

                @Override
                public long cost() {
                    return scoreDocs.length;
                }
            };
            return new VectorSimilarityScorer(weight, iterator, cachedScore);
        }

        static VectorSimilarityScorer fromAcceptDocs(Weight weight, final float boost, final VectorScorer scorer, DocIdSetIterator acceptDocs, final float threshold) {
            if (scorer == null) {
                return null;
            }
            final float[] cachedScore = new float[1];
            final DocIdSetIterator vectorIterator = scorer.iterator();
            DocIdSetIterator conjunction = ConjunctionDISI.createConjunction(List.of(vectorIterator, acceptDocs), List.of());
            FilteredDocIdSetIterator iterator = new FilteredDocIdSetIterator(conjunction){

                @Override
                protected boolean match(int doc) throws IOException {
                    assert (doc == vectorIterator.docID());
                    float score = scorer.score();
                    cachedScore[0] = score * boost;
                    return score >= threshold;
                }
            };
            return new VectorSimilarityScorer(weight, iterator, cachedScore);
        }

        @Override
        public int docID() {
            return this.iterator.docID();
        }

        @Override
        public DocIdSetIterator iterator() {
            return this.iterator;
        }

        @Override
        public float getMaxScore(int upTo) {
            return Float.POSITIVE_INFINITY;
        }

        @Override
        public float score() {
            return this.cachedScore[0];
        }
    }
}

