/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.search;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.DocValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.IndexReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.SortedDocValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.SortedSetDocValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.Terms;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.TermsEnum;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.BooleanClause;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.ConstantScoreQuery;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.ConstantScoreScorer;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.ConstantScoreWeight;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.DisjunctionMatchesIterator;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.DocIdSetIterator;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.IndexSearcher;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Matches;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.MatchesUtils;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.MultiTermQuery;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Query;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.QueryVisitor;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.ScoreMode;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Scorer;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.ScorerSupplier;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.TwoPhaseIterator;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Weight;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.LongBitSet;

public final class DocValuesRewriteMethod
extends MultiTermQuery.RewriteMethod {
    @Override
    public Query rewrite(IndexReader reader, MultiTermQuery query) {
        return new ConstantScoreQuery(new MultiTermQueryDocValuesWrapper(query));
    }

    public boolean equals(Object other) {
        return other != null && this.getClass() == other.getClass();
    }

    public int hashCode() {
        return 641;
    }

    static class MultiTermQueryDocValuesWrapper
    extends Query {
        protected final MultiTermQuery query;

        protected MultiTermQueryDocValuesWrapper(MultiTermQuery query) {
            this.query = query;
        }

        @Override
        public String toString(String field) {
            return this.query.toString(field);
        }

        @Override
        public final boolean equals(Object other) {
            return this.sameClassAs(other) && this.query.equals(((MultiTermQueryDocValuesWrapper)other).query);
        }

        @Override
        public final int hashCode() {
            return 31 * this.classHash() + this.query.hashCode();
        }

        public final String getField() {
            return this.query.getField();
        }

        @Override
        public void visit(QueryVisitor visitor) {
            if (visitor.acceptField(this.query.getField())) {
                visitor.getSubVisitor(BooleanClause.Occur.FILTER, this.query);
            }
        }

        @Override
        public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
            return new ConstantScoreWeight(this, boost){

                @Override
                public Matches matches(LeafReaderContext context, int doc) throws IOException {
                    SortedSetDocValues values = DocValues.getSortedSet(context.reader(), query.field);
                    return MatchesUtils.forField(query.field, () -> DisjunctionMatchesIterator.fromTermsEnum(context, doc, query, query.field, this.getTermsEnum(values)));
                }

                private TermsEnum getTermsEnum(final SortedSetDocValues values) throws IOException {
                    return query.getTermsEnum(new Terms(){

                        @Override
                        public TermsEnum iterator() throws IOException {
                            return values.termsEnum();
                        }

                        @Override
                        public long getSumTotalTermFreq() {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public long getSumDocFreq() {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public int getDocCount() {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public long size() {
                            return -1L;
                        }

                        @Override
                        public boolean hasFreqs() {
                            return false;
                        }

                        @Override
                        public boolean hasOffsets() {
                            return false;
                        }

                        @Override
                        public boolean hasPositions() {
                            return false;
                        }

                        @Override
                        public boolean hasPayloads() {
                            return false;
                        }
                    });
                }

                @Override
                public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
                    final SortedSetDocValues values = DocValues.getSortedSet(context.reader(), query.field);
                    if (values.getValueCount() == 0L) {
                        return null;
                    }
                    final 1 weight = this;
                    return new ScorerSupplier(){

                        @Override
                        public Scorer get(long leadCost) throws IOException {
                            TermsEnum termsEnum = this.getTermsEnum(values);
                            assert (termsEnum != null);
                            if (termsEnum.next() == null) {
                                return new ConstantScoreScorer(weight, this.score(), scoreMode, DocIdSetIterator.empty());
                            }
                            final LongBitSet termSet = new LongBitSet(values.getValueCount());
                            long maxOrd = -1L;
                            do {
                                long ord;
                                if ((ord = termsEnum.ord()) < 0L) continue;
                                assert (ord > maxOrd);
                                maxOrd = ord;
                                termSet.set(ord);
                            } while (termsEnum.next() != null);
                            if (maxOrd < 0L) {
                                return new ConstantScoreScorer(weight, this.score(), scoreMode, DocIdSetIterator.empty());
                            }
                            final SortedDocValues singleton = DocValues.unwrapSingleton(values);
                            final long max = maxOrd;
                            TwoPhaseIterator iterator = singleton != null ? new TwoPhaseIterator(singleton){

                                @Override
                                public boolean matches() throws IOException {
                                    return termSet.get(singleton.ordValue());
                                }

                                @Override
                                public float matchCost() {
                                    return 3.0f;
                                }
                            } : new TwoPhaseIterator(values){

                                @Override
                                public boolean matches() throws IOException {
                                    for (int i = 0; i < values.docValueCount(); ++i) {
                                        long value = values.nextOrd();
                                        if (value > max) {
                                            return false;
                                        }
                                        if (!termSet.get(value)) continue;
                                        return true;
                                    }
                                    return false;
                                }

                                @Override
                                public float matchCost() {
                                    return 3.0f;
                                }
                            };
                            return new ConstantScoreScorer(weight, this.score(), scoreMode, iterator);
                        }

                        @Override
                        public long cost() {
                            return values.cost();
                        }
                    };
                }

                @Override
                public Scorer scorer(LeafReaderContext context) throws IOException {
                    ScorerSupplier scorerSupplier = this.scorerSupplier(context);
                    if (scorerSupplier == null) {
                        return null;
                    }
                    return scorerSupplier.get(Long.MAX_VALUE);
                }

                @Override
                public boolean isCacheable(LeafReaderContext ctx) {
                    return DocValues.isCacheable(ctx, query.field);
                }
            };
        }
    }
}

