/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.search;

import java.io.IOException;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.ByteVectorValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.DocValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.DocValuesIterator;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.DocValuesType;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.FieldInfo;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.FieldInfos;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.FloatVectorValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.IndexOptions;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.IndexReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.LeafReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.PointValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.Terms;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.ConstantScoreScorer;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.ConstantScoreWeight;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.DocIdSetIterator;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.IndexSearcher;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.MatchAllDocsQuery;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Query;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.QueryVisitor;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.ScoreMode;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Scorer;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Weight;

public class FieldExistsQuery
extends Query {
    private final String field;

    public FieldExistsQuery(String field) {
        this.field = Objects.requireNonNull(field);
    }

    public static DocIdSetIterator getDocValuesDocIdSetIterator(String field, LeafReader reader) throws IOException {
        FieldInfo fieldInfo = reader.getFieldInfos().fieldInfo(field);
        if (fieldInfo != null) {
            DocValuesIterator iterator;
            switch (fieldInfo.getDocValuesType()) {
                case NONE: {
                    iterator = null;
                    break;
                }
                case NUMERIC: {
                    iterator = reader.getNumericDocValues(field);
                    break;
                }
                case BINARY: {
                    iterator = reader.getBinaryDocValues(field);
                    break;
                }
                case SORTED: {
                    iterator = reader.getSortedDocValues(field);
                    break;
                }
                case SORTED_NUMERIC: {
                    iterator = reader.getSortedNumericDocValues(field);
                    break;
                }
                case SORTED_SET: {
                    iterator = reader.getSortedSetDocValues(field);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            return iterator;
        }
        return null;
    }

    public String getField() {
        return this.field;
    }

    @Override
    public String toString(String field) {
        return "FieldExistsQuery [field=" + this.field + "]";
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            visitor.visitLeaf(this);
        }
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.field.equals(((FieldExistsQuery)other).field);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int hash = this.classHash();
        hash = 31 * hash + this.field.hashCode();
        return hash;
    }

    @Override
    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        IndexReader reader = indexSearcher.getIndexReader();
        boolean allReadersRewritable = true;
        for (LeafReaderContext context : reader.leaves()) {
            LeafReader leaf = context.reader();
            FieldInfos fieldInfos = leaf.getFieldInfos();
            FieldInfo fieldInfo = fieldInfos.fieldInfo(this.field);
            if (fieldInfo == null) {
                allReadersRewritable = false;
                break;
            }
            if (fieldInfo.hasNorms()) {
                if (reader.getDocCount(this.field) == reader.maxDoc()) continue;
                allReadersRewritable = false;
                break;
            }
            if (fieldInfo.getVectorDimension() != 0) {
                if (this.getVectorValuesSize(fieldInfo, leaf) == leaf.maxDoc()) continue;
                allReadersRewritable = false;
                break;
            }
            if (fieldInfo.getDocValuesType() != DocValuesType.NONE) {
                if (!this.hasStrictlyConsistentFieldInfos(context)) {
                    allReadersRewritable = false;
                    break;
                }
                Terms terms = leaf.terms(this.field);
                PointValues pointValues = leaf.getPointValues(this.field);
                if (terms != null && terms.getDocCount() == leaf.maxDoc() || pointValues != null && pointValues.getDocCount() == leaf.maxDoc()) continue;
                allReadersRewritable = false;
                break;
            }
            if (!this.hasStrictlyConsistentFieldInfos(context)) continue;
            throw new IllegalStateException(this.buildErrorMsg(fieldInfo));
        }
        if (allReadersRewritable) {
            return new MatchAllDocsQuery();
        }
        return super.rewrite(indexSearcher);
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) {
        return new ConstantScoreWeight(this, boost){

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                DocIdSetIterator iterator;
                block15: {
                    FieldInfo fieldInfo;
                    block17: {
                        block16: {
                            block14: {
                                FieldInfos fieldInfos = context.reader().getFieldInfos();
                                fieldInfo = fieldInfos.fieldInfo(FieldExistsQuery.this.field);
                                iterator = null;
                                if (fieldInfo == null) {
                                    return null;
                                }
                                if (!fieldInfo.hasNorms()) break block14;
                                iterator = context.reader().getNormValues(FieldExistsQuery.this.field);
                                break block15;
                            }
                            if (fieldInfo.getVectorDimension() == 0) break block16;
                            switch (fieldInfo.getVectorEncoding()) {
                                case FLOAT32: {
                                    iterator = context.reader().getFloatVectorValues(FieldExistsQuery.this.field);
                                    break block15;
                                }
                                case BYTE: {
                                    iterator = context.reader().getByteVectorValues(FieldExistsQuery.this.field);
                                    break block15;
                                }
                                default: {
                                    throw new IllegalArgumentException("unknown vector encoding=" + fieldInfo.getVectorEncoding());
                                }
                            }
                        }
                        if (fieldInfo.getDocValuesType() == DocValuesType.NONE) break block17;
                        switch (fieldInfo.getDocValuesType()) {
                            case NUMERIC: {
                                iterator = context.reader().getNumericDocValues(FieldExistsQuery.this.field);
                                break block15;
                            }
                            case BINARY: {
                                iterator = context.reader().getBinaryDocValues(FieldExistsQuery.this.field);
                                break block15;
                            }
                            case SORTED: {
                                iterator = context.reader().getSortedDocValues(FieldExistsQuery.this.field);
                                break block15;
                            }
                            case SORTED_NUMERIC: {
                                iterator = context.reader().getSortedNumericDocValues(FieldExistsQuery.this.field);
                                break block15;
                            }
                            case SORTED_SET: {
                                iterator = context.reader().getSortedSetDocValues(FieldExistsQuery.this.field);
                                break block15;
                            }
                            default: {
                                throw new AssertionError();
                            }
                        }
                    }
                    if (FieldExistsQuery.this.hasStrictlyConsistentFieldInfos(context)) {
                        throw new IllegalStateException(FieldExistsQuery.this.buildErrorMsg(fieldInfo));
                    }
                }
                if (iterator == null) {
                    return null;
                }
                return new ConstantScoreScorer((Weight)this, this.score(), scoreMode, iterator);
            }

            @Override
            public int count(LeafReaderContext context) throws IOException {
                LeafReader reader = context.reader();
                FieldInfos fieldInfos = reader.getFieldInfos();
                FieldInfo fieldInfo = fieldInfos.fieldInfo(FieldExistsQuery.this.field);
                if (fieldInfo == null) {
                    return 0;
                }
                if (fieldInfo.hasNorms()) {
                    if (reader.getDocCount(FieldExistsQuery.this.field) == reader.maxDoc()) {
                        return reader.numDocs();
                    }
                    return super.count(context);
                }
                if (fieldInfo.hasVectorValues()) {
                    if (!reader.hasDeletions()) {
                        return FieldExistsQuery.this.getVectorValuesSize(fieldInfo, reader);
                    }
                    return super.count(context);
                }
                if (fieldInfo.getDocValuesType() != DocValuesType.NONE) {
                    if (!reader.hasDeletions()) {
                        if (fieldInfo.getPointDimensionCount() > 0) {
                            PointValues pointValues = reader.getPointValues(FieldExistsQuery.this.field);
                            return pointValues == null ? 0 : pointValues.getDocCount();
                        }
                        if (fieldInfo.getIndexOptions() != IndexOptions.NONE) {
                            Terms terms = reader.terms(FieldExistsQuery.this.field);
                            return terms == null ? 0 : terms.getDocCount();
                        }
                    }
                    return super.count(context);
                }
                if (FieldExistsQuery.this.hasStrictlyConsistentFieldInfos(context)) {
                    throw new IllegalStateException(FieldExistsQuery.this.buildErrorMsg(fieldInfo));
                }
                return super.count(context);
            }

            @Override
            public boolean isCacheable(LeafReaderContext context) {
                FieldInfos fieldInfos = context.reader().getFieldInfos();
                FieldInfo fieldInfo = fieldInfos.fieldInfo(FieldExistsQuery.this.field);
                if (fieldInfo != null && fieldInfo.getDocValuesType() != DocValuesType.NONE) {
                    return DocValues.isCacheable(context, FieldExistsQuery.this.field);
                }
                return true;
            }
        };
    }

    private boolean hasStrictlyConsistentFieldInfos(LeafReaderContext context) {
        return context.reader().getMetaData() != null && context.reader().getMetaData().getCreatedVersionMajor() >= 9;
    }

    private String buildErrorMsg(FieldInfo fieldInfo) {
        return "FieldExistsQuery requires that the field indexes doc values, norms or vectors, but field '" + fieldInfo.name + "' exists and indexes neither of these data structures";
    }

    private int getVectorValuesSize(FieldInfo fi, LeafReader reader) throws IOException {
        assert (fi.name.equals(this.field));
        switch (fi.getVectorEncoding()) {
            case FLOAT32: {
                FloatVectorValues floatVectorValues = reader.getFloatVectorValues(this.field);
                assert (floatVectorValues != null) : "unexpected null float vector values";
                return floatVectorValues.size();
            }
            case BYTE: {
                ByteVectorValues byteVectorValues = reader.getByteVectorValues(this.field);
                assert (byteVectorValues != null) : "unexpected null byte vector values";
                return byteVectorValues.size();
            }
        }
        throw new IllegalArgumentException("unknown vector encoding=" + fi.getVectorEncoding());
    }
}

