/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.search;

import java.util.concurrent.atomic.LongAdder;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.ScoreMode;

abstract class HitsThresholdChecker {
    private static final HitsThresholdChecker EXACT_HITS_COUNT_THRESHOLD_CHECKER = new HitsThresholdChecker(Integer.MAX_VALUE){

        @Override
        void incrementHitCount() {
        }

        @Override
        boolean isThresholdReached() {
            return false;
        }

        @Override
        ScoreMode scoreMode() {
            return ScoreMode.COMPLETE;
        }
    };
    private final int totalHitsThreshold;

    static HitsThresholdChecker create(int totalHitsThreshold) {
        return totalHitsThreshold == Integer.MAX_VALUE ? EXACT_HITS_COUNT_THRESHOLD_CHECKER : new LocalHitsThresholdChecker(totalHitsThreshold);
    }

    static HitsThresholdChecker createShared(int totalHitsThreshold) {
        return totalHitsThreshold == Integer.MAX_VALUE ? EXACT_HITS_COUNT_THRESHOLD_CHECKER : new GlobalHitsThresholdChecker(totalHitsThreshold);
    }

    HitsThresholdChecker(int totalHitsThreshold) {
        if (totalHitsThreshold < 0) {
            throw new IllegalArgumentException("totalHitsThreshold must be >= 0, got " + totalHitsThreshold);
        }
        this.totalHitsThreshold = totalHitsThreshold;
    }

    final int getHitsThreshold() {
        return this.totalHitsThreshold;
    }

    abstract boolean isThresholdReached();

    abstract ScoreMode scoreMode();

    abstract void incrementHitCount();

    private static class LocalHitsThresholdChecker
    extends HitsThresholdChecker {
        private int hitCount;

        LocalHitsThresholdChecker(int totalHitsThreshold) {
            super(totalHitsThreshold);
            assert (totalHitsThreshold != Integer.MAX_VALUE);
        }

        @Override
        void incrementHitCount() {
            ++this.hitCount;
        }

        @Override
        boolean isThresholdReached() {
            return this.hitCount > this.getHitsThreshold();
        }

        @Override
        ScoreMode scoreMode() {
            return ScoreMode.TOP_SCORES;
        }
    }

    private static class GlobalHitsThresholdChecker
    extends HitsThresholdChecker {
        private final LongAdder globalHitCount = new LongAdder();
        private boolean thresholdReached = false;

        GlobalHitsThresholdChecker(int totalHitsThreshold) {
            super(totalHitsThreshold);
            assert (totalHitsThreshold != Integer.MAX_VALUE);
        }

        @Override
        void incrementHitCount() {
            if (!this.thresholdReached) {
                this.globalHitCount.increment();
            }
        }

        @Override
        boolean isThresholdReached() {
            if (this.thresholdReached) {
                return true;
            }
            this.thresholdReached = this.globalHitCount.longValue() > (long)this.getHitsThreshold();
            return this.thresholdReached;
        }

        @Override
        ScoreMode scoreMode() {
            return ScoreMode.TOP_SCORES;
        }
    }
}

