/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.BulkScorer;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.DisiPriorityQueue;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.DisiWrapper;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.LeafCollector;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Scorable;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Scorer;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.Bits;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.FixedBitSet;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.MathUtil;

final class MaxScoreBulkScorer
extends BulkScorer {
    static final int INNER_WINDOW_SIZE = 4096;
    private final int maxDoc;
    final DisiWrapper[] allScorers;
    private final DisiWrapper[] scratch;
    private final DisiPriorityQueue essentialQueue;
    int firstEssentialScorer;
    int firstRequiredScorer;
    private final long cost;
    float minCompetitiveScore;
    private final ScoreAndDoc scorable = new ScoreAndDoc();
    final double[] maxScoreSums;
    private final long[] windowMatches = new long[FixedBitSet.bits2words(4096)];
    private final double[] windowScores = new double[4096];

    MaxScoreBulkScorer(int maxDoc, List<Scorer> scorers) throws IOException {
        this.maxDoc = maxDoc;
        this.allScorers = new DisiWrapper[scorers.size()];
        this.scratch = new DisiWrapper[this.allScorers.length];
        int i = 0;
        long cost = 0L;
        for (Scorer scorer : scorers) {
            DisiWrapper w = new DisiWrapper(scorer);
            cost += w.cost;
            this.allScorers[i++] = w;
        }
        this.cost = cost;
        this.essentialQueue = new DisiPriorityQueue(this.allScorers.length);
        this.maxScoreSums = new double[this.allScorers.length];
    }

    @Override
    public int score(LeafCollector collector, Bits acceptDocs, int min, int max) throws IOException {
        collector.setScorer(this.scorable);
        int outerWindowMin = min;
        block0: while (outerWindowMin < max) {
            int outerWindowMax = this.computeOuterWindowMax(outerWindowMin);
            outerWindowMax = Math.min(outerWindowMax, max);
            while (true) {
                this.updateMaxWindowScores(outerWindowMin, outerWindowMax);
                if (!this.partitionScorers()) {
                    outerWindowMin = outerWindowMax;
                    continue block0;
                }
                int newOuterWindowMax = this.computeOuterWindowMax(outerWindowMin);
                if (newOuterWindowMax >= outerWindowMax) break;
                outerWindowMax = newOuterWindowMax;
            }
            DisiWrapper top = this.essentialQueue.top();
            while (top.doc < outerWindowMin) {
                top.doc = top.iterator.advance(outerWindowMin);
                top = this.essentialQueue.updateTop();
            }
            while (top.doc < outerWindowMax) {
                this.scoreInnerWindow(collector, acceptDocs, outerWindowMax);
                top = this.essentialQueue.top();
            }
            outerWindowMin = outerWindowMax;
        }
        return this.nextCandidate(max);
    }

    private void scoreInnerWindow(LeafCollector collector, Bits acceptDocs, int max) throws IOException {
        if (this.allScorers.length - this.firstRequiredScorer >= 2) {
            this.scoreInnerWindowAsConjunction(collector, acceptDocs, max);
        } else {
            DisiWrapper top = this.essentialQueue.top();
            DisiWrapper top2 = this.essentialQueue.top2();
            if (top2 == null) {
                this.scoreInnerWindowSingleEssentialClause(collector, acceptDocs, max);
            } else if (top2.doc - 2048 >= top.doc) {
                this.scoreInnerWindowSingleEssentialClause(collector, acceptDocs, Math.min(max, top2.doc));
            } else {
                this.scoreInnerWindowMultipleEssentialClauses(collector, acceptDocs, max);
            }
        }
    }

    private void scoreInnerWindowSingleEssentialClause(LeafCollector collector, Bits acceptDocs, int upTo) throws IOException {
        DisiWrapper top = this.essentialQueue.top();
        int doc = top.doc;
        while (doc < upTo) {
            if (acceptDocs == null || acceptDocs.get(doc)) {
                this.scoreNonEssentialClauses(collector, doc, top.scorer.score(), this.firstEssentialScorer);
            }
            doc = top.iterator.nextDoc();
        }
        top.doc = top.iterator.docID();
        this.essentialQueue.updateTop();
    }

    private void scoreInnerWindowAsConjunction(LeafCollector collector, Bits acceptDocs, int max) throws IOException {
        assert (this.firstEssentialScorer == this.allScorers.length - 1);
        assert (this.firstRequiredScorer <= this.allScorers.length - 2);
        DisiWrapper lead1 = this.allScorers[this.allScorers.length - 1];
        assert (this.essentialQueue.size() == 1);
        assert (lead1 == this.essentialQueue.top());
        DisiWrapper lead2 = this.allScorers[this.allScorers.length - 2];
        if (lead1.doc < lead2.doc) {
            lead1.doc = lead1.iterator.advance(Math.min(lead2.doc, max));
        }
        double maxScoreSumAtLead2 = this.maxScoreSums[this.allScorers.length - 2];
        block0: while (lead1.doc < max) {
            if (acceptDocs != null && !acceptDocs.get(lead1.doc)) {
                lead1.doc = lead1.iterator.nextDoc();
                continue;
            }
            double score = lead1.scorer.score();
            if ((float)MathUtil.sumUpperBound(score + maxScoreSumAtLead2, this.allScorers.length) < this.minCompetitiveScore) {
                lead1.doc = lead1.iterator.nextDoc();
                continue;
            }
            if (lead2.doc < lead1.doc) {
                lead2.doc = lead2.iterator.advance(lead1.doc);
            }
            if (lead2.doc != lead1.doc) {
                lead1.doc = lead1.iterator.advance(Math.min(lead2.doc, max));
                continue;
            }
            score += (double)lead2.scorer.score();
            for (int i = this.allScorers.length - 3; i >= this.firstRequiredScorer; --i) {
                if ((float)MathUtil.sumUpperBound(score + this.maxScoreSums[i], this.allScorers.length) < this.minCompetitiveScore) {
                    lead1.doc = lead1.iterator.nextDoc();
                    continue block0;
                }
                DisiWrapper w = this.allScorers[i];
                if (w.doc < lead1.doc) {
                    w.doc = w.iterator.advance(lead1.doc);
                }
                if (w.doc != lead1.doc) {
                    lead1.doc = lead1.iterator.advance(Math.min(w.doc, max));
                    continue block0;
                }
                score += (double)w.scorer.score();
            }
            this.scoreNonEssentialClauses(collector, lead1.doc, score, this.firstRequiredScorer);
            lead1.doc = lead1.iterator.nextDoc();
        }
    }

    private void scoreInnerWindowMultipleEssentialClauses(LeafCollector collector, Bits acceptDocs, int max) throws IOException {
        DisiWrapper top = this.essentialQueue.top();
        int innerWindowMin = top.doc;
        int innerWindowMax = (int)Math.min((long)max, (long)innerWindowMin + 4096L);
        do {
            int doc = top.doc;
            while (doc < innerWindowMax) {
                if (acceptDocs == null || acceptDocs.get(doc)) {
                    int i = doc - innerWindowMin;
                    int n = i >>> 6;
                    this.windowMatches[n] = this.windowMatches[n] | 1L << i;
                    int n2 = i;
                    this.windowScores[n2] = this.windowScores[n2] + (double)top.scorer.score();
                }
                doc = top.iterator.nextDoc();
            }
            top.doc = top.iterator.docID();
            top = this.essentialQueue.updateTop();
        } while (top.doc < innerWindowMax);
        for (int wordIndex = 0; wordIndex < this.windowMatches.length; ++wordIndex) {
            int ntz;
            this.windowMatches[wordIndex] = 0L;
            for (long bits = this.windowMatches[wordIndex]; bits != 0L; bits ^= 1L << ntz) {
                ntz = Long.numberOfTrailingZeros(bits);
                int index = wordIndex << 6 | ntz;
                int doc = innerWindowMin + index;
                double score = this.windowScores[index];
                this.windowScores[index] = 0.0;
                this.scoreNonEssentialClauses(collector, doc, score, this.firstEssentialScorer);
            }
        }
    }

    private int computeOuterWindowMax(int windowMin) throws IOException {
        int firstWindowLead = Math.min(this.firstEssentialScorer, this.allScorers.length - 1);
        int windowMax = Integer.MAX_VALUE;
        for (int i = firstWindowLead; i < this.allScorers.length; ++i) {
            DisiWrapper scorer = this.allScorers[i];
            int upTo = scorer.scorer.advanceShallow(Math.max(scorer.doc, windowMin));
            windowMax = (int)Math.min((long)windowMax, (long)upTo + 1L);
        }
        return windowMax;
    }

    void updateMaxWindowScores(int windowMin, int windowMax) throws IOException {
        for (DisiWrapper scorer : this.allScorers) {
            if (scorer.doc < windowMax) {
                if (scorer.doc < windowMin) {
                    scorer.scorer.advanceShallow(windowMin);
                }
                scorer.maxWindowScore = scorer.scorer.getMaxScore(windowMax - 1);
                continue;
            }
            scorer.maxWindowScore = 0.0f;
        }
    }

    private void scoreNonEssentialClauses(LeafCollector collector, int doc, double essentialScore, int numNonEssentialClauses) throws IOException {
        double score = essentialScore;
        for (int i = numNonEssentialClauses - 1; i >= 0; --i) {
            float maxPossibleScore = (float)MathUtil.sumUpperBound(score + this.maxScoreSums[i], this.allScorers.length);
            if (maxPossibleScore < this.minCompetitiveScore) {
                return;
            }
            DisiWrapper scorer = this.allScorers[i];
            if (scorer.doc < doc) {
                scorer.doc = scorer.iterator.advance(doc);
            }
            if (scorer.doc != doc) continue;
            score += (double)scorer.scorer.score();
        }
        this.scorable.doc = doc;
        this.scorable.score = (float)score;
        collector.collect(doc);
    }

    boolean partitionScorers() {
        int i;
        System.arraycopy(this.allScorers, 0, this.scratch, 0, this.allScorers.length);
        Arrays.sort(this.scratch, (scorer1, scorer2) -> Double.compare((double)scorer1.maxWindowScore / (double)Math.max(1L, scorer1.cost), (double)scorer2.maxWindowScore / (double)Math.max(1L, scorer2.cost)));
        double maxScoreSum = 0.0;
        this.firstEssentialScorer = 0;
        for (i = 0; i < this.allScorers.length; ++i) {
            DisiWrapper w = this.scratch[i];
            double newMaxScoreSum = maxScoreSum + (double)w.maxWindowScore;
            float maxScoreSumFloat = (float)MathUtil.sumUpperBound(newMaxScoreSum, this.firstEssentialScorer + 1);
            if (maxScoreSumFloat < this.minCompetitiveScore) {
                maxScoreSum = newMaxScoreSum;
                this.allScorers[this.firstEssentialScorer] = w;
                this.maxScoreSums[this.firstEssentialScorer] = maxScoreSum;
                ++this.firstEssentialScorer;
                continue;
            }
            this.allScorers[this.allScorers.length - 1 - (i - this.firstEssentialScorer)] = w;
        }
        this.firstRequiredScorer = this.allScorers.length;
        if (this.firstEssentialScorer == this.allScorers.length) {
            return false;
        }
        this.essentialQueue.clear();
        for (i = this.firstEssentialScorer; i < this.allScorers.length; ++i) {
            this.essentialQueue.add(this.allScorers[i]);
        }
        if (this.firstEssentialScorer == this.allScorers.length - 1) {
            this.firstRequiredScorer = this.allScorers.length - 1;
            double maxRequiredScore = this.allScorers[this.firstEssentialScorer].maxWindowScore;
            while (this.firstRequiredScorer > 0) {
                double maxPossibleScoreWithoutPreviousClause = maxRequiredScore;
                if (this.firstRequiredScorer > 1) {
                    maxPossibleScoreWithoutPreviousClause += this.maxScoreSums[this.firstRequiredScorer - 2];
                }
                if ((float)maxPossibleScoreWithoutPreviousClause >= this.minCompetitiveScore) break;
                --this.firstRequiredScorer;
                maxRequiredScore += (double)this.allScorers[this.firstRequiredScorer].maxWindowScore;
            }
        }
        return true;
    }

    private int nextCandidate(int rangeEnd) {
        if (rangeEnd >= this.maxDoc) {
            return Integer.MAX_VALUE;
        }
        int next = Integer.MAX_VALUE;
        for (DisiWrapper scorer : this.allScorers) {
            if (scorer.doc < rangeEnd) {
                return rangeEnd;
            }
            next = Math.min(next, scorer.doc);
        }
        return next;
    }

    @Override
    public long cost() {
        return this.cost;
    }

    private class ScoreAndDoc
    extends Scorable {
        float score;
        int doc = -1;

        private ScoreAndDoc() {
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public float score() {
            return this.score;
        }

        @Override
        public void setMinCompetitiveScore(float minScore) throws IOException {
            MaxScoreBulkScorer.this.minCompetitiveScore = minScore;
        }
    }
}

