/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.search;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Scorable;

public final class ScoreCachingWrappingScorer
extends Scorable {
    private int curDoc = -1;
    private float curScore;
    private final Scorable in;

    public static Scorable wrap(Scorable scorer) {
        if (scorer instanceof ScoreCachingWrappingScorer) {
            return scorer;
        }
        return new ScoreCachingWrappingScorer(scorer);
    }

    private ScoreCachingWrappingScorer(Scorable scorer) {
        this.in = scorer;
    }

    @Override
    public float score() throws IOException {
        int doc = this.in.docID();
        if (doc != this.curDoc) {
            this.curScore = this.in.score();
            this.curDoc = doc;
        }
        return this.curScore;
    }

    @Override
    public void setMinCompetitiveScore(float minScore) throws IOException {
        this.in.setMinCompetitiveScore(minScore);
    }

    @Override
    public int docID() {
        return this.in.docID();
    }

    @Override
    public Collection<Scorable.ChildScorable> getChildren() {
        return Collections.singleton(new Scorable.ChildScorable(this.in, "CACHED"));
    }
}

