/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.IOUtils;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.ThreadInterruptedException;

public final class TaskExecutor {
    private final Executor executor;

    public TaskExecutor(Executor executor) {
        Objects.requireNonNull(executor, "Executor is null");
        this.executor = r -> {
            try {
                executor.execute(r);
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                r.run();
            }
        };
    }

    public <T> List<T> invokeAll(Collection<Callable<T>> callables) throws IOException {
        TaskGroup<T> taskGroup = new TaskGroup<T>(callables);
        return taskGroup.invokeAll(this.executor);
    }

    public String toString() {
        return "TaskExecutor(executor=" + this.executor + ")";
    }

    private static final class TaskGroup<T> {
        private final List<RunnableFuture<T>> futures;

        TaskGroup(Collection<Callable<T>> callables) {
            ArrayList<RunnableFuture<T>> tasks = new ArrayList<RunnableFuture<T>>(callables.size());
            for (Callable<T> callable : callables) {
                tasks.add(this.createTask(callable));
            }
            this.futures = Collections.unmodifiableList(tasks);
        }

        RunnableFuture<T> createTask(Callable<T> callable) {
            return new FutureTask<T>(callable){
                private final AtomicBoolean startedOrCancelled;
                {
                    super(arg0);
                    this.startedOrCancelled = new AtomicBoolean(false);
                }

                @Override
                public void run() {
                    if (this.startedOrCancelled.compareAndSet(false, true)) {
                        super.run();
                    }
                }

                @Override
                protected void setException(Throwable t) {
                    super.setException(t);
                    this.cancelAll();
                }

                @Override
                public boolean cancel(boolean mayInterruptIfRunning) {
                    assert (!mayInterruptIfRunning) : "cancelling tasks that are running is not supported";
                    if (this.startedOrCancelled.compareAndSet(false, true)) {
                        this.set(null);
                        return true;
                    }
                    return false;
                }
            };
        }

        List<T> invokeAll(Executor executor) throws IOException {
            int id;
            int count = this.futures.size();
            AtomicInteger taskId = new AtomicInteger(0);
            if (count > 1) {
                Runnable work = () -> {
                    int id = taskId.getAndIncrement();
                    if (id < count) {
                        this.futures.get(id).run();
                    }
                };
                for (int j = 0; j < count - 1; ++j) {
                    executor.execute(work);
                }
            }
            while ((id = taskId.getAndIncrement()) < count) {
                this.futures.get(id).run();
                if (id < count - 1) continue;
            }
            Throwable exc = null;
            ArrayList results = new ArrayList(count);
            for (int i = 0; i < count; ++i) {
                Future future = this.futures.get(i);
                try {
                    results.add(future.get());
                    continue;
                }
                catch (InterruptedException e) {
                    exc = IOUtils.useOrSuppress(exc, new ThreadInterruptedException(e));
                    continue;
                }
                catch (ExecutionException e) {
                    exc = IOUtils.useOrSuppress(exc, e.getCause());
                }
            }
            assert (this.assertAllFuturesCompleted()) : "Some tasks are still running?";
            if (exc != null) {
                throw IOUtils.rethrowAlways(exc);
            }
            return results;
        }

        private boolean assertAllFuturesCompleted() {
            for (RunnableFuture<T> future : this.futures) {
                if (future.isDone()) continue;
                return false;
            }
            return true;
        }

        private void cancelAll() {
            for (Future future : this.futures) {
                future.cancel(false);
            }
        }
    }
}

