/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.search.highlight;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.Analyzer;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.TokenStream;
import org.graylog.shaded.opensearch2.org.apache.lucene.document.Document;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.Fields;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.IndexReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.Terms;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.highlight.LimitTokenOffsetFilter;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.highlight.TokenStreamFromTermVector;

public class TokenSources {
    private TokenSources() {
    }

    public static TokenStream getTokenStream(String field, Fields tvFields, String text, Analyzer analyzer, int maxStartOffset) throws IOException {
        TokenStream tokenStream = TokenSources.getTermVectorTokenStreamOrNull(field, tvFields, maxStartOffset);
        if (tokenStream != null) {
            return tokenStream;
        }
        tokenStream = analyzer.tokenStream(field, text);
        if (maxStartOffset >= 0 && maxStartOffset < text.length() - 1) {
            tokenStream = new LimitTokenOffsetFilter(tokenStream, maxStartOffset);
        }
        return tokenStream;
    }

    public static TokenStream getTermVectorTokenStreamOrNull(String field, Fields tvFields, int maxStartOffset) throws IOException {
        if (tvFields == null) {
            return null;
        }
        Terms tvTerms = tvFields.terms(field);
        if (tvTerms == null || !tvTerms.hasOffsets()) {
            return null;
        }
        return new TokenStreamFromTermVector(tvTerms, maxStartOffset);
    }

    @Deprecated
    public static TokenStream getAnyTokenStream(IndexReader reader, int docId, String field, Document document, Analyzer analyzer) throws IOException {
        Terms vector;
        TokenStream ts = null;
        Fields vectors = reader.termVectors().get(docId);
        if (vectors != null && (vector = vectors.terms(field)) != null) {
            ts = TokenSources.getTokenStream(vector);
        }
        if (ts == null) {
            ts = TokenSources.getTokenStream(document, field, analyzer);
        }
        return ts;
    }

    @Deprecated
    public static TokenStream getAnyTokenStream(IndexReader reader, int docId, String field, Analyzer analyzer) throws IOException {
        Terms vector;
        TokenStream ts = null;
        Fields vectors = reader.termVectors().get(docId);
        if (vectors != null && (vector = vectors.terms(field)) != null) {
            ts = TokenSources.getTokenStream(vector);
        }
        if (ts == null) {
            ts = TokenSources.getTokenStream(reader, docId, field, analyzer);
        }
        return ts;
    }

    @Deprecated
    public static TokenStream getTokenStream(Terms vector, boolean tokenPositionsGuaranteedContiguous) throws IOException {
        return TokenSources.getTokenStream(vector);
    }

    @Deprecated
    public static TokenStream getTokenStream(Terms tpv) throws IOException {
        if (!tpv.hasOffsets()) {
            throw new IllegalArgumentException("Highlighting requires offsets from the TokenStream.");
        }
        return new TokenStreamFromTermVector(tpv, -1);
    }

    @Deprecated
    public static TokenStream getTokenStreamWithOffsets(IndexReader reader, int docId, String field) throws IOException {
        Fields vectors = reader.termVectors().get(docId);
        if (vectors == null) {
            return null;
        }
        Terms vector = vectors.terms(field);
        if (vector == null) {
            return null;
        }
        if (!vector.hasOffsets()) {
            return null;
        }
        return TokenSources.getTokenStream(vector);
    }

    @Deprecated
    public static TokenStream getTokenStream(IndexReader reader, int docId, String field, Analyzer analyzer) throws IOException {
        Document doc = reader.storedFields().document(docId);
        return TokenSources.getTokenStream(doc, field, analyzer);
    }

    @Deprecated
    public static TokenStream getTokenStream(Document doc, String field, Analyzer analyzer) {
        String contents = doc.get(field);
        if (contents == null) {
            throw new IllegalArgumentException("Field " + field + " in document is not stored and cannot be analyzed");
        }
        return TokenSources.getTokenStream(field, contents, analyzer);
    }

    @Deprecated
    public static TokenStream getTokenStream(String field, String contents, Analyzer analyzer) {
        return analyzer.tokenStream(field, contents);
    }
}

