/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.search.join;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import org.graylog.shaded.opensearch2.org.apache.lucene.document.DoublePoint;
import org.graylog.shaded.opensearch2.org.apache.lucene.document.FloatPoint;
import org.graylog.shaded.opensearch2.org.apache.lucene.document.IntPoint;
import org.graylog.shaded.opensearch2.org.apache.lucene.document.LongPoint;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.DocValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.LeafReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.NumericDocValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.OrdinalMap;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.SortedDocValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.SortedNumericDocValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.SortedSetDocValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.internal.hppc.LongArrayList;
import org.graylog.shaded.opensearch2.org.apache.lucene.internal.hppc.LongCursor;
import org.graylog.shaded.opensearch2.org.apache.lucene.internal.hppc.LongFloatHashMap;
import org.graylog.shaded.opensearch2.org.apache.lucene.internal.hppc.LongHashSet;
import org.graylog.shaded.opensearch2.org.apache.lucene.internal.hppc.LongIntHashMap;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Collector;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.IndexSearcher;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.MatchNoDocsQuery;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.PointInSetQuery;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Query;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Scorable;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.SimpleCollector;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.join.DocValuesTermsCollector;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.join.GenericTermsCollector;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.join.GlobalOrdinalsCollector;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.join.GlobalOrdinalsQuery;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.join.GlobalOrdinalsWithScoreCollector;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.join.GlobalOrdinalsWithScoreQuery;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.join.PointInSetIncludingScoreQuery;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.join.ScoreMode;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.join.TermsIncludingScoreQuery;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.join.TermsQuery;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.BytesRef;

public final class JoinUtil {
    private JoinUtil() {
    }

    public static Query createJoinQuery(String fromField, boolean multipleValuesPerDocument, String toField, Query fromQuery, IndexSearcher fromSearcher, ScoreMode scoreMode) throws IOException {
        GenericTermsCollector termsWithScoreCollector;
        if (multipleValuesPerDocument) {
            DocValuesTermsCollector.Function<SortedSetDocValues> mvFunction = DocValuesTermsCollector.sortedSetDocValues(fromField);
            termsWithScoreCollector = GenericTermsCollector.createCollectorMV(mvFunction, scoreMode);
        } else {
            DocValuesTermsCollector.Function<SortedDocValues> svFunction = DocValuesTermsCollector.sortedDocValues(fromField);
            termsWithScoreCollector = GenericTermsCollector.createCollectorSV(svFunction, scoreMode);
        }
        return JoinUtil.createJoinQuery(multipleValuesPerDocument, toField, fromQuery, fromField, fromSearcher, scoreMode, termsWithScoreCollector);
    }

    public static Query createJoinQuery(final String fromField, boolean multipleValuesPerDocument, String toField, final Class<? extends Number> numericType, Query fromQuery, IndexSearcher fromSearcher, ScoreMode scoreMode) throws IOException {
        PointInSetIncludingScoreQuery.Stream stream;
        int bytesPerDim;
        boolean needsScore;
        final LongHashSet joinValues = new LongHashSet();
        LongFloatHashMap aggregatedScores = new LongFloatHashMap();
        LongIntHashMap occurrences = new LongIntHashMap();
        boolean bl = needsScore = scoreMode != ScoreMode.None;
        final LongFloatProcedure scoreAggregator = scoreMode == ScoreMode.Max ? (key, score) -> {
            int index = aggregatedScores.indexOf(key);
            if (index < 0) {
                aggregatedScores.indexInsert(index, key, score);
            } else {
                float currentScore = aggregatedScores.indexGet(index);
                aggregatedScores.indexReplace(index, Math.max(currentScore, score));
            }
        } : (scoreMode == ScoreMode.Min ? (key, score) -> {
            int index = aggregatedScores.indexOf(key);
            if (index < 0) {
                aggregatedScores.indexInsert(index, key, score);
            } else {
                float currentScore = aggregatedScores.indexGet(index);
                aggregatedScores.indexReplace(index, Math.min(currentScore, score));
            }
        } : (scoreMode == ScoreMode.Total ? aggregatedScores::addTo : (scoreMode == ScoreMode.Avg ? (key, score) -> {
            aggregatedScores.addTo(key, score);
            occurrences.addTo(key, 1);
        } : (key, score) -> {
            throw new UnsupportedOperationException();
        })));
        final LongFloatFunction joinScorer = scoreMode == ScoreMode.Avg ? joinValue -> {
            float aggregatedScore = aggregatedScores.get(joinValue);
            int occurrence = occurrences.get(joinValue);
            return aggregatedScore / (float)occurrence;
        } : aggregatedScores::get;
        SimpleCollector collector = multipleValuesPerDocument ? new SimpleCollector(){
            SortedNumericDocValues sortedNumericDocValues;
            Scorable scorer;

            @Override
            public void collect(int doc) throws IOException {
                if (this.sortedNumericDocValues.advanceExact(doc)) {
                    int count = this.sortedNumericDocValues.docValueCount();
                    for (int i = 0; i < count; ++i) {
                        long value = this.sortedNumericDocValues.nextValue();
                        joinValues.add(value);
                        if (!needsScore) continue;
                        scoreAggregator.apply(value, this.scorer.score());
                    }
                }
            }

            @Override
            protected void doSetNextReader(LeafReaderContext context) throws IOException {
                this.sortedNumericDocValues = DocValues.getSortedNumeric(context.reader(), fromField);
            }

            @Override
            public void setScorer(Scorable scorer) throws IOException {
                this.scorer = scorer;
            }

            @Override
            public org.graylog.shaded.opensearch2.org.apache.lucene.search.ScoreMode scoreMode() {
                return needsScore ? org.graylog.shaded.opensearch2.org.apache.lucene.search.ScoreMode.COMPLETE : org.graylog.shaded.opensearch2.org.apache.lucene.search.ScoreMode.COMPLETE_NO_SCORES;
            }
        } : new SimpleCollector(){
            NumericDocValues numericDocValues;
            Scorable scorer;
            private int lastDocID = -1;

            private boolean docsInOrder(int docID) {
                if (docID < this.lastDocID) {
                    throw new AssertionError((Object)("docs out of order: lastDocID=" + this.lastDocID + " vs docID=" + docID));
                }
                this.lastDocID = docID;
                return true;
            }

            @Override
            public void collect(int doc) throws IOException {
                assert (this.docsInOrder(doc));
                long value = 0L;
                if (this.numericDocValues.advanceExact(doc)) {
                    value = this.numericDocValues.longValue();
                }
                joinValues.add(value);
                if (needsScore) {
                    scoreAggregator.apply(value, this.scorer.score());
                }
            }

            @Override
            protected void doSetNextReader(LeafReaderContext context) throws IOException {
                this.numericDocValues = DocValues.getNumeric(context.reader(), fromField);
                this.lastDocID = -1;
            }

            @Override
            public void setScorer(Scorable scorer) throws IOException {
                this.scorer = scorer;
            }

            @Override
            public org.graylog.shaded.opensearch2.org.apache.lucene.search.ScoreMode scoreMode() {
                return needsScore ? org.graylog.shaded.opensearch2.org.apache.lucene.search.ScoreMode.COMPLETE : org.graylog.shaded.opensearch2.org.apache.lucene.search.ScoreMode.COMPLETE_NO_SCORES;
            }
        };
        fromSearcher.search(fromQuery, collector);
        LongArrayList joinValuesList = new LongArrayList(joinValues.size());
        joinValuesList.addAll(joinValues);
        Arrays.sort(joinValuesList.buffer, 0, joinValuesList.size());
        final Iterator<LongCursor> iterator = joinValuesList.iterator();
        final BytesRef encoded = new BytesRef();
        if (Integer.class.equals(numericType)) {
            bytesPerDim = 4;
            stream = new PointInSetIncludingScoreQuery.Stream(){

                @Override
                public BytesRef next() {
                    if (iterator.hasNext()) {
                        LongCursor value = (LongCursor)iterator.next();
                        IntPoint.encodeDimension((int)value.value, encoded.bytes, 0);
                        if (needsScore) {
                            this.score = joinScorer.apply(value.value);
                        }
                        return encoded;
                    }
                    return null;
                }
            };
        } else if (Long.class.equals(numericType)) {
            bytesPerDim = 8;
            stream = new PointInSetIncludingScoreQuery.Stream(){

                @Override
                public BytesRef next() {
                    if (iterator.hasNext()) {
                        LongCursor value = (LongCursor)iterator.next();
                        LongPoint.encodeDimension(value.value, encoded.bytes, 0);
                        if (needsScore) {
                            this.score = joinScorer.apply(value.value);
                        }
                        return encoded;
                    }
                    return null;
                }
            };
        } else if (Float.class.equals(numericType)) {
            bytesPerDim = 4;
            stream = new PointInSetIncludingScoreQuery.Stream(){

                @Override
                public BytesRef next() {
                    if (iterator.hasNext()) {
                        LongCursor value = (LongCursor)iterator.next();
                        FloatPoint.encodeDimension(Float.intBitsToFloat((int)value.value), encoded.bytes, 0);
                        if (needsScore) {
                            this.score = joinScorer.apply(value.value);
                        }
                        return encoded;
                    }
                    return null;
                }
            };
        } else if (Double.class.equals(numericType)) {
            bytesPerDim = 8;
            stream = new PointInSetIncludingScoreQuery.Stream(){

                @Override
                public BytesRef next() {
                    if (iterator.hasNext()) {
                        LongCursor value = (LongCursor)iterator.next();
                        DoublePoint.encodeDimension(Double.longBitsToDouble(value.value), encoded.bytes, 0);
                        if (needsScore) {
                            this.score = joinScorer.apply(value.value);
                        }
                        return encoded;
                    }
                    return null;
                }
            };
        } else {
            throw new IllegalArgumentException("unsupported numeric type, only Integer, Long, Float and Double are supported");
        }
        encoded.bytes = new byte[bytesPerDim];
        encoded.length = bytesPerDim;
        if (needsScore) {
            return new PointInSetIncludingScoreQuery(scoreMode, fromQuery, multipleValuesPerDocument, toField, bytesPerDim, stream){

                @Override
                protected String toString(byte[] value) {
                    return (String)toString.apply(value, numericType);
                }
            };
        }
        return new PointInSetQuery(toField, 1, bytesPerDim, stream){

            @Override
            protected String toString(byte[] value) {
                return PointInSetIncludingScoreQuery.toString.apply(value, numericType);
            }
        };
    }

    private static Query createJoinQuery(boolean multipleValuesPerDocument, String toField, Query fromQuery, String fromField, IndexSearcher fromSearcher, ScoreMode scoreMode, GenericTermsCollector collector) throws IOException {
        fromSearcher.search(fromQuery, collector);
        switch (scoreMode) {
            case None: {
                return new TermsQuery(toField, collector.getCollectedTerms(), fromField, fromQuery, fromSearcher.getTopReaderContext().id());
            }
            case Total: 
            case Max: 
            case Min: 
            case Avg: {
                return new TermsIncludingScoreQuery(scoreMode, toField, multipleValuesPerDocument, collector.getCollectedTerms(), collector.getScoresPerTerm(), fromField, fromQuery, fromSearcher.getTopReaderContext().id());
            }
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "Score mode %s isn't supported.", new Object[]{scoreMode}));
    }

    public static Query createJoinQuery(String joinField, Query fromQuery, Query toQuery, IndexSearcher searcher, ScoreMode scoreMode, OrdinalMap ordinalMap) throws IOException {
        return JoinUtil.createJoinQuery(joinField, fromQuery, toQuery, searcher, scoreMode, ordinalMap, 0, Integer.MAX_VALUE);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Query createJoinQuery(String joinField, Query fromQuery, Query toQuery, IndexSearcher searcher, ScoreMode scoreMode, OrdinalMap ordinalMap, int min, int max) throws IOException {
        void var13_17;
        long valueCount;
        int numSegments = searcher.getIndexReader().leaves().size();
        if (numSegments == 0) {
            return new MatchNoDocsQuery("JoinUtil.createJoinQuery with no segments");
        }
        if (numSegments == 1) {
            ordinalMap = null;
            LeafReader leafReader = searcher.getIndexReader().leaves().get(0).reader();
            SortedDocValues joinSortedDocValues = leafReader.getSortedDocValues(joinField);
            if (joinSortedDocValues == null) return new MatchNoDocsQuery("JoinUtil.createJoinQuery: no join values");
            valueCount = joinSortedDocValues.getValueCount();
        } else {
            if (ordinalMap == null) {
                throw new IllegalArgumentException("OrdinalMap is required, because there is more than 1 segment");
            }
            valueCount = ordinalMap.getValueCount();
        }
        Query rewrittenFromQuery = searcher.rewrite(fromQuery);
        Query rewrittenToQuery = searcher.rewrite(toQuery);
        switch (scoreMode) {
            case Total: {
                GlobalOrdinalsWithScoreCollector.Sum sum = new GlobalOrdinalsWithScoreCollector.Sum(joinField, ordinalMap, valueCount, min, max);
                break;
            }
            case Min: {
                GlobalOrdinalsWithScoreCollector.Min min2 = new GlobalOrdinalsWithScoreCollector.Min(joinField, ordinalMap, valueCount, min, max);
                break;
            }
            case Max: {
                GlobalOrdinalsWithScoreCollector.Max max2 = new GlobalOrdinalsWithScoreCollector.Max(joinField, ordinalMap, valueCount, min, max);
                break;
            }
            case Avg: {
                GlobalOrdinalsWithScoreCollector.Avg avg = new GlobalOrdinalsWithScoreCollector.Avg(joinField, ordinalMap, valueCount, min, max);
                break;
            }
            case None: {
                if (min <= 1 && max == Integer.MAX_VALUE) {
                    GlobalOrdinalsCollector globalOrdinalsCollector = new GlobalOrdinalsCollector(joinField, ordinalMap, valueCount);
                    searcher.search(rewrittenFromQuery, globalOrdinalsCollector);
                    return new GlobalOrdinalsQuery(globalOrdinalsCollector.getCollectorOrdinals(), joinField, ordinalMap, rewrittenToQuery, rewrittenFromQuery, searcher.getTopReaderContext().id());
                }
                GlobalOrdinalsWithScoreCollector.NoScore noScore = new GlobalOrdinalsWithScoreCollector.NoScore(joinField, ordinalMap, valueCount, min, max);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Score mode %s isn't supported.", new Object[]{scoreMode}));
            }
        }
        searcher.search(rewrittenFromQuery, (Collector)var13_17);
        return new GlobalOrdinalsWithScoreQuery((GlobalOrdinalsWithScoreCollector)var13_17, scoreMode, joinField, ordinalMap, rewrittenToQuery, rewrittenFromQuery, min, max, searcher.getTopReaderContext().id());
    }

    private static interface LongFloatProcedure {
        public void apply(long var1, float var3);
    }

    private static interface LongFloatFunction {
        public float apply(long var1);
    }
}

