/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.search.join;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.FilteredTermsEnum;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.TermsEnum;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.BytesRefHash;

public class SeekingTermSetTermsEnum
extends FilteredTermsEnum {
    private final BytesRefHash terms;
    private final int[] ords;
    private final int lastElement;
    private final BytesRef lastTerm;
    private final BytesRef spare = new BytesRef();
    private BytesRef seekTerm;
    private int upto = 0;

    public SeekingTermSetTermsEnum(TermsEnum tenum, BytesRefHash terms, int[] ords) {
        super(tenum);
        this.terms = terms;
        this.ords = ords;
        this.lastElement = terms.size() - 1;
        this.lastTerm = terms.get(ords[this.lastElement], new BytesRef());
        this.seekTerm = terms.get(ords[this.upto], this.spare);
    }

    @Override
    protected BytesRef nextSeekTerm(BytesRef currentTerm) throws IOException {
        BytesRef temp = this.seekTerm;
        this.seekTerm = null;
        return temp;
    }

    @Override
    protected FilteredTermsEnum.AcceptStatus accept(BytesRef term) throws IOException {
        int cmp;
        if (term.compareTo(this.lastTerm) > 0) {
            return FilteredTermsEnum.AcceptStatus.END;
        }
        BytesRef currentTerm = this.terms.get(this.ords[this.upto], this.spare);
        if (term.compareTo(currentTerm) == 0) {
            if (this.upto == this.lastElement) {
                return FilteredTermsEnum.AcceptStatus.YES;
            }
            this.seekTerm = this.terms.get(this.ords[++this.upto], this.spare);
            return FilteredTermsEnum.AcceptStatus.YES_AND_SEEK;
        }
        if (this.upto == this.lastElement) {
            return FilteredTermsEnum.AcceptStatus.NO;
        }
        do {
            if (this.upto == this.lastElement) {
                return FilteredTermsEnum.AcceptStatus.NO;
            }
            this.seekTerm = this.terms.get(this.ords[++this.upto], this.spare);
        } while ((cmp = this.seekTerm.compareTo(term)) < 0);
        if (cmp == 0) {
            if (this.upto == this.lastElement) {
                return FilteredTermsEnum.AcceptStatus.YES;
            }
            this.seekTerm = this.terms.get(this.ords[++this.upto], this.spare);
            return FilteredTermsEnum.AcceptStatus.YES_AND_SEEK;
        }
        return FilteredTermsEnum.AcceptStatus.NO_AND_SEEK;
    }
}

