/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.search.matchhighlight;

import java.util.Objects;

public class OffsetRange
implements Cloneable {
    public final int from;
    public final int to;

    public OffsetRange(int from, int to) {
        assert (from <= to) : "A non-empty offset range is required: " + from + "-" + to;
        this.from = from;
        this.to = to;
    }

    public int length() {
        return this.to - this.from;
    }

    public String toString() {
        return "[from=" + this.from + ", to=" + this.to + "]";
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof OffsetRange) {
            OffsetRange that = (OffsetRange)other;
            return this.from == that.from && this.to == that.to;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.from, this.to);
    }

    public OffsetRange slice(int from, int to) {
        assert (from >= this.from);
        assert (to <= this.to);
        return new OffsetRange(from, to);
    }

    public boolean contains(OffsetRange other) {
        return this.from <= other.from && this.to >= other.to;
    }

    public OffsetRange clone() {
        return new OffsetRange(this.from, this.to);
    }
}

