/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.search.similarities;

import java.util.ArrayList;
import java.util.List;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Explanation;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.similarities.BasicStats;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.similarities.SimilarityBase;

public abstract class Axiomatic
extends SimilarityBase {
    protected final float s;
    protected final float k;
    protected final int queryLen;

    public Axiomatic(float s, int queryLen, float k) {
        this(true, s, queryLen, k);
    }

    public Axiomatic(boolean discountOverlaps, float s, int queryLen, float k) {
        super(discountOverlaps);
        if (!Float.isFinite(s) || Float.isNaN(s) || s < 0.0f || s > 1.0f) {
            throw new IllegalArgumentException("illegal s value: " + s + ", must be between 0 and 1");
        }
        if (!Float.isFinite(k) || Float.isNaN(k) || k < 0.0f || k > 1.0f) {
            throw new IllegalArgumentException("illegal k value: " + k + ", must be between 0 and 1");
        }
        if (queryLen < 0 || queryLen > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("illegal query length value: " + queryLen + ", must be larger 0 and smaller than MAX_INT");
        }
        this.s = s;
        this.queryLen = queryLen;
        this.k = k;
    }

    public Axiomatic(float s) {
        this(s, 1, 0.35f);
    }

    public Axiomatic(float s, int queryLen) {
        this(s, queryLen, 0.35f);
    }

    public Axiomatic() {
        this(0.25f, 1, 0.35f);
    }

    @Override
    public double score(BasicStats stats, double freq, double docLen) {
        double score = this.tf(stats, freq, docLen) * this.ln(stats, freq, docLen) * this.tfln(stats, freq, docLen) * this.idf(stats, freq, docLen) - this.gamma(stats, freq, docLen);
        return Math.max(0.0, score *= stats.boost);
    }

    @Override
    protected Explanation explain(BasicStats stats, Explanation freq, double docLen) {
        ArrayList<Explanation> subs = new ArrayList<Explanation>();
        double f = freq.getValue().doubleValue();
        this.explain(subs, stats, f, docLen);
        double score = this.tf(stats, f, docLen) * this.ln(stats, f, docLen) * this.tfln(stats, f, docLen) * this.idf(stats, f, docLen) - this.gamma(stats, f, docLen);
        Explanation explanation = Explanation.match((Number)Float.valueOf((float)score), "score(" + this.getClass().getSimpleName() + ", freq=" + freq.getValue() + "), computed from:", subs);
        if (stats.boost != 1.0) {
            explanation = Explanation.match((Number)Float.valueOf((float)(score * stats.boost)), "Boosted score, computed as (score * boost) from:", explanation, Explanation.match((Number)Float.valueOf((float)stats.boost), "Query boost", new Explanation[0]));
        }
        if (score < 0.0) {
            explanation = Explanation.match((Number)0, "max of:", Explanation.match((Number)0, "Minimum legal score", new Explanation[0]), explanation);
        }
        return explanation;
    }

    @Override
    protected void explain(List<Explanation> subs, BasicStats stats, double freq, double docLen) {
        if (stats.getBoost() != 1.0) {
            subs.add(Explanation.match((Number)Float.valueOf((float)stats.getBoost()), "boost, query boost", new Explanation[0]));
        }
        subs.add(Explanation.match((Number)Float.valueOf(this.k), "k, hyperparam for the primitive weighting function", new Explanation[0]));
        subs.add(Explanation.match((Number)Float.valueOf(this.s), "s, hyperparam for the growth function", new Explanation[0]));
        subs.add(Explanation.match((Number)this.queryLen, "queryLen, query length", new Explanation[0]));
        subs.add(this.tfExplain(stats, freq, docLen));
        subs.add(this.lnExplain(stats, freq, docLen));
        subs.add(this.tflnExplain(stats, freq, docLen));
        subs.add(this.idfExplain(stats, freq, docLen));
        subs.add(Explanation.match((Number)Float.valueOf((float)this.gamma(stats, freq, docLen)), "gamma", new Explanation[0]));
        super.explain(subs, stats, freq, docLen);
    }

    @Override
    public abstract String toString();

    protected abstract double tf(BasicStats var1, double var2, double var4);

    protected abstract double ln(BasicStats var1, double var2, double var4);

    protected abstract double tfln(BasicStats var1, double var2, double var4);

    protected abstract double idf(BasicStats var1, double var2, double var4);

    protected abstract double gamma(BasicStats var1, double var2, double var4);

    protected abstract Explanation tfExplain(BasicStats var1, double var2, double var4);

    protected abstract Explanation lnExplain(BasicStats var1, double var2, double var4);

    protected abstract Explanation tflnExplain(BasicStats var1, double var2, double var4);

    protected abstract Explanation idfExplain(BasicStats var1, double var2, double var4);
}

