/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.search.suggest.analyzing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.Analyzer;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.TokenStreamToAutomaton;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.suggest.analyzing.AnalyzingSuggester;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.suggest.analyzing.FSTUtil;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.Directory;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.IntsRef;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.UnicodeUtil;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.automaton.Automata;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.automaton.Automaton;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.automaton.FiniteStringsIterator;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.automaton.LevenshteinAutomata;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.automaton.Operations;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.automaton.UTF32ToUTF8;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.fst.FST;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.fst.PairOutputs;

public final class FuzzySuggester
extends AnalyzingSuggester {
    private final int maxEdits;
    private final boolean transpositions;
    private final int nonFuzzyPrefix;
    private final int minFuzzyLength;
    private final boolean unicodeAware;
    public static final boolean DEFAULT_UNICODE_AWARE = false;
    public static final int DEFAULT_MIN_FUZZY_LENGTH = 3;
    public static final int DEFAULT_NON_FUZZY_PREFIX = 1;
    public static final int DEFAULT_MAX_EDITS = 1;
    public static final boolean DEFAULT_TRANSPOSITIONS = true;

    public FuzzySuggester(Directory tempDir, String tempFileNamePrefix, Analyzer analyzer) {
        this(tempDir, tempFileNamePrefix, analyzer, analyzer);
    }

    public FuzzySuggester(Directory tempDir, String tempFileNamePrefix, Analyzer indexAnalyzer, Analyzer queryAnalyzer) {
        this(tempDir, tempFileNamePrefix, indexAnalyzer, queryAnalyzer, 3, 256, -1, true, 1, true, 1, 3, false);
    }

    public FuzzySuggester(Directory tempDir, String tempFileNamePrefix, Analyzer indexAnalyzer, Analyzer queryAnalyzer, int options, int maxSurfaceFormsPerAnalyzedForm, int maxGraphExpansions, boolean preservePositionIncrements, int maxEdits, boolean transpositions, int nonFuzzyPrefix, int minFuzzyLength, boolean unicodeAware) {
        super(tempDir, tempFileNamePrefix, indexAnalyzer, queryAnalyzer, options, maxSurfaceFormsPerAnalyzedForm, maxGraphExpansions, preservePositionIncrements);
        if (maxEdits < 0 || maxEdits > 2) {
            throw new IllegalArgumentException("maxEdits must be between 0 and 2");
        }
        if (nonFuzzyPrefix < 0) {
            throw new IllegalArgumentException("nonFuzzyPrefix must not be >= 0 (got " + nonFuzzyPrefix + ")");
        }
        if (minFuzzyLength < 0) {
            throw new IllegalArgumentException("minFuzzyLength must not be >= 0 (got " + minFuzzyLength + ")");
        }
        this.maxEdits = maxEdits;
        this.transpositions = transpositions;
        this.nonFuzzyPrefix = nonFuzzyPrefix;
        this.minFuzzyLength = minFuzzyLength;
        this.unicodeAware = unicodeAware;
    }

    @Override
    protected List<FSTUtil.Path<PairOutputs.Pair<Long, BytesRef>>> getFullPrefixPaths(List<FSTUtil.Path<PairOutputs.Pair<Long, BytesRef>>> prefixPaths, Automaton lookupAutomaton, FST<PairOutputs.Pair<Long, BytesRef>> fst) throws IOException {
        Automaton levA = this.convertAutomaton(this.toLevenshteinAutomata(lookupAutomaton));
        return FSTUtil.intersectPrefixPaths(levA, fst);
    }

    @Override
    protected Automaton convertAutomaton(Automaton a) {
        if (this.unicodeAware) {
            Automaton utf8automaton = new UTF32ToUTF8().convert(a);
            utf8automaton = Operations.determinize(utf8automaton, 10000);
            return utf8automaton;
        }
        return a;
    }

    @Override
    TokenStreamToAutomaton getTokenStreamToAutomaton() {
        TokenStreamToAutomaton tsta = super.getTokenStreamToAutomaton();
        tsta.setUnicodeArcs(this.unicodeAware);
        return tsta;
    }

    Automaton toLevenshteinAutomata(Automaton automaton) {
        IntsRef string;
        ArrayList<Automaton> subs = new ArrayList<Automaton>();
        FiniteStringsIterator finiteStrings = new FiniteStringsIterator(automaton);
        while ((string = finiteStrings.next()) != null) {
            if (string.length <= this.nonFuzzyPrefix || string.length < this.minFuzzyLength) {
                subs.add(Automata.makeString(string.ints, string.offset, string.length));
                continue;
            }
            int[] ints = new int[string.length - this.nonFuzzyPrefix];
            System.arraycopy(string.ints, string.offset + this.nonFuzzyPrefix, ints, 0, ints.length);
            LevenshteinAutomata lev = new LevenshteinAutomata(ints, this.unicodeAware ? 0x10FFFF : 255, this.transpositions);
            subs.add(lev.toAutomaton(this.maxEdits, UnicodeUtil.newString(string.ints, string.offset, this.nonFuzzyPrefix)));
        }
        if (subs.isEmpty()) {
            return Automata.makeEmpty();
        }
        if (subs.size() == 1) {
            return (Automaton)subs.get(0);
        }
        Automaton a = Operations.union(subs);
        return Operations.determinize(a, 10000);
    }
}

