/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.spatial.util;

import java.io.IOException;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.DoubleValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.DoubleValuesSource;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Explanation;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.IndexSearcher;

public class ReciprocalDoubleValuesSource
extends DoubleValuesSource {
    private final double distToEdge;
    private final DoubleValuesSource input;

    public ReciprocalDoubleValuesSource(double distToEdge, DoubleValuesSource input) {
        this.distToEdge = distToEdge;
        this.input = input;
    }

    @Override
    public DoubleValues getValues(LeafReaderContext ctx, DoubleValues scores) throws IOException {
        final DoubleValues in = this.input.getValues(ctx, scores);
        return new DoubleValues(){

            @Override
            public double doubleValue() throws IOException {
                return ReciprocalDoubleValuesSource.this.recip(in.doubleValue());
            }

            @Override
            public boolean advanceExact(int doc) throws IOException {
                return in.advanceExact(doc);
            }
        };
    }

    private double recip(double in) {
        return this.distToEdge / (in + this.distToEdge);
    }

    @Override
    public boolean needsScores() {
        return this.input.needsScores();
    }

    @Override
    public boolean isCacheable(LeafReaderContext ctx) {
        return this.input.isCacheable(ctx);
    }

    @Override
    public Explanation explain(LeafReaderContext ctx, int docId, Explanation scoreExplanation) throws IOException {
        Explanation expl = this.input.explain(ctx, docId, scoreExplanation);
        return Explanation.match((Number)this.recip(expl.getValue().doubleValue()), this.distToEdge + " / (v + " + this.distToEdge + "), computed from:", expl);
    }

    @Override
    public DoubleValuesSource rewrite(IndexSearcher searcher) throws IOException {
        return new ReciprocalDoubleValuesSource(this.distToEdge, this.input.rewrite(searcher));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReciprocalDoubleValuesSource that = (ReciprocalDoubleValuesSource)o;
        return Double.compare(that.distToEdge, this.distToEdge) == 0 && Objects.equals(this.input, that.input);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.distToEdge, this.input);
    }

    @Override
    public String toString() {
        return "recip(" + this.distToEdge + ", " + this.input.toString() + ")";
    }
}

