/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.store;

import java.io.IOException;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.SymbolLookup;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.util.Locale;
import java.util.Optional;
import java.util.logging.Logger;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.IOContext;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.NativeAccess;

/*
 * Exception performing whole class analysis ignored.
 */
final class PosixNativeAccess
extends NativeAccess {
    private static final Logger LOG = Logger.getLogger(PosixNativeAccess.class.getName());
    public static final int POSIX_MADV_NORMAL = 0;
    public static final int POSIX_MADV_RANDOM = 1;
    public static final int POSIX_MADV_SEQUENTIAL = 2;
    public static final int POSIX_MADV_WILLNEED = 3;
    public static final int POSIX_MADV_DONTNEED = 4;
    private static final MethodHandle MH$posix_madvise;
    private static final Optional<NativeAccess> INSTANCE;

    private PosixNativeAccess() {
    }

    static Optional<NativeAccess> getInstance() {
        return INSTANCE;
    }

    private static MethodHandle lookupMadvise() {
        Linker linker = Linker.nativeLinker();
        SymbolLookup stdlib = linker.defaultLookup();
        return PosixNativeAccess.findFunction((Linker)linker, (SymbolLookup)stdlib, (String)"posix_madvise", (FunctionDescriptor)FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.JAVA_LONG, ValueLayout.JAVA_INT));
    }

    private static MethodHandle findFunction(Linker linker, SymbolLookup lookup, String name, FunctionDescriptor desc) {
        MemorySegment symbol = lookup.find(name).orElseThrow(() -> new UnsupportedOperationException("Platform has no symbol for '" + name + "' in libc."));
        return linker.downcallHandle(symbol, desc, new Linker.Option[0]);
    }

    public void madvise(MemorySegment segment, IOContext context) throws IOException {
        int ret;
        if (segment.byteSize() == 0L) {
            return;
        }
        Integer advice = this.mapIOContext(context);
        if (advice == null) {
            return;
        }
        try {
            ret = MH$posix_madvise.invokeExact(segment, segment.byteSize(), advice);
        }
        catch (Throwable th) {
            throw new AssertionError((Object)th);
        }
        if (ret != 0) {
            throw new IOException(String.format(Locale.ENGLISH, "Call to posix_madvise with address=0x%08X and byteSize=%d failed with return code %d.", segment.address(), segment.byteSize(), ret));
        }
    }

    private Integer mapIOContext(IOContext ctx) {
        if (ctx.context == IOContext.Context.MERGE) {
            return 2;
        }
        if (ctx.randomAccess) {
            return 1;
        }
        if (ctx.readOnce) {
            return 2;
        }
        return null;
    }

    static {
        MethodHandle adviseHandle = null;
        PosixNativeAccess instance = null;
        try {
            adviseHandle = PosixNativeAccess.lookupMadvise();
            instance = new PosixNativeAccess();
        }
        catch (UnsupportedOperationException uoe) {
            LOG.warning(uoe.getMessage());
        }
        catch (IllegalCallerException ice) {
            LOG.warning(String.format(Locale.ENGLISH, "Lucene has no access to native functions. To enable access to native functions, pass the following on command line: --enable-native-access=%s", Optional.ofNullable(PosixNativeAccess.class.getModule().getName()).orElse("ALL-UNNAMED")));
        }
        MH$posix_madvise = adviseHandle;
        INSTANCE = Optional.ofNullable(instance);
    }
}

