/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.util;

import java.util.Arrays;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.ArrayUtil;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.StringHelper;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.UnicodeUtil;

public final class BytesRef
implements Comparable<BytesRef>,
Cloneable {
    public static final byte[] EMPTY_BYTES = new byte[0];
    public byte[] bytes;
    public int offset;
    public int length;

    public BytesRef() {
        this(EMPTY_BYTES);
    }

    public BytesRef(byte[] bytes, int offset, int length) {
        this.bytes = bytes;
        this.offset = offset;
        this.length = length;
        assert (this.isValid());
    }

    public BytesRef(byte[] bytes) {
        this(bytes, 0, bytes.length);
    }

    public BytesRef(int capacity) {
        this.bytes = capacity == 0 ? EMPTY_BYTES : new byte[capacity];
    }

    public BytesRef(CharSequence text) {
        this(UnicodeUtil.maxUTF8Length(text.length()));
        this.length = UnicodeUtil.UTF16toUTF8(text, 0, text.length(), this.bytes);
    }

    public boolean bytesEquals(BytesRef other) {
        return Arrays.equals(this.bytes, this.offset, this.offset + this.length, other.bytes, other.offset, other.offset + other.length);
    }

    public BytesRef clone() {
        return new BytesRef(this.bytes, this.offset, this.length);
    }

    public int hashCode() {
        return StringHelper.murmurhash3_x86_32(this, StringHelper.GOOD_FAST_HASH_SEED);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof BytesRef) {
            return this.bytesEquals((BytesRef)other);
        }
        return false;
    }

    public String utf8ToString() {
        char[] ref = new char[this.length];
        int len = UnicodeUtil.UTF8toUTF16(this.bytes, this.offset, this.length, ref);
        return new String(ref, 0, len);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(2 + 3 * this.length);
        sb.append('[');
        int end = this.offset + this.length;
        for (int i = this.offset; i < end; ++i) {
            if (i > this.offset) {
                sb.append(' ');
            }
            sb.append(Integer.toHexString(this.bytes[i] & 0xFF));
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public int compareTo(BytesRef other) {
        return Arrays.compareUnsigned(this.bytes, this.offset, this.offset + this.length, other.bytes, other.offset, other.offset + other.length);
    }

    public static BytesRef deepCopyOf(BytesRef other) {
        return new BytesRef(ArrayUtil.copyOfSubArray(other.bytes, other.offset, other.offset + other.length), 0, other.length);
    }

    public boolean isValid() {
        if (this.bytes == null) {
            throw new IllegalStateException("bytes is null");
        }
        if (this.length < 0) {
            throw new IllegalStateException("length is negative: " + this.length);
        }
        if (this.length > this.bytes.length) {
            throw new IllegalStateException("length is out of bounds: " + this.length + ",bytes.length=" + this.bytes.length);
        }
        if (this.offset < 0) {
            throw new IllegalStateException("offset is negative: " + this.offset);
        }
        if (this.offset > this.bytes.length) {
            throw new IllegalStateException("offset out of bounds: " + this.offset + ",bytes.length=" + this.bytes.length);
        }
        if (this.offset + this.length < 0) {
            throw new IllegalStateException("offset+length is negative: offset=" + this.offset + ",length=" + this.length);
        }
        if (this.offset + this.length > this.bytes.length) {
            throw new IllegalStateException("offset+length out of bounds: offset=" + this.offset + ",length=" + this.length + ",bytes.length=" + this.bytes.length);
        }
        return true;
    }
}

