/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.util;

import org.graylog.shaded.opensearch2.org.apache.lucene.util.BitSet;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.Bits;

public final class CombinedBitSet
extends BitSet
implements Bits {
    private final BitSet first;
    private final Bits second;
    private final int length;

    public CombinedBitSet(BitSet first, Bits second) {
        this.first = first;
        this.second = second;
        this.length = first.length();
    }

    public BitSet getFirst() {
        return this.first;
    }

    @Override
    public int cardinality() {
        int card = 0;
        for (int i = 0; i < this.length; ++i) {
            card += this.get(i) ? 1 : 0;
        }
        return card;
    }

    @Override
    public int approximateCardinality() {
        return this.first.cardinality();
    }

    @Override
    public int prevSetBit(int index) {
        assert (index >= 0 && index < this.length) : "index=" + index + ", numBits=" + this.length();
        int prev = this.first.prevSetBit(index);
        while (prev != -1 && !this.second.get(prev)) {
            if (prev == 0) {
                return -1;
            }
            prev = this.first.prevSetBit(prev - 1);
        }
        return prev;
    }

    @Override
    public int nextSetBit(int index) {
        return this.nextSetBit(index, this.length() - 1);
    }

    @Override
    public long ramBytesUsed() {
        return this.first.ramBytesUsed();
    }

    @Override
    public boolean get(int index) {
        return this.first.get(index) && this.second.get(index);
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public void set(int i) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void clear(int i) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void clear(int startIndex, int endIndex) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public boolean getAndSet(int i) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public int nextSetBit(int start, int end) {
        assert (start >= 0 && start < this.length()) : "start=" + start + " numBits=" + this.length();
        assert (end >= start && end < this.length()) : "end=" + end + " numBits=" + this.length();
        int next = this.first.nextSetBit(start);
        while (next != Integer.MAX_VALUE && !this.second.get(next)) {
            if (next >= end) {
                return Integer.MAX_VALUE;
            }
            next = this.first.nextSetBit(next + 1);
        }
        return next;
    }
}

